package com.mmc.csf.release.entity.requirements;

import com.mmc.csf.infomation.dto.PlatformOrderEarningsDTO;
import com.mmc.csf.infomation.dto.ServiceOrderFormDetailsDTO;
import com.mmc.csf.release.model.group.Insert;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/8/29 13:52
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class ServiceOrderFormDetailsDO {
    private static final long serialVersionUID = -447951390213113317L;
    @ApiModelProperty(value = "id")
    @NotNull(message = "id不能为空", groups = {Update.class})
    private Integer id;


    @ApiModelProperty(value = "发单时间", example = "2023-07-26 16:50:12")
    private String createTime;

    @ApiModelProperty(value = "服务类型id", example = "1")
    @NotBlank(message = "服务类型id不能为空", groups = {Insert.class, Update.class})
    private Integer serviceId;

    @ApiModelProperty(value = "服务类型名称", example = "航拍摄影")
    private String serviceName;

    @ApiModelProperty(value = "发布者订单编号", example = "R3123132132132131")
    private String publisherNumber;


    @ApiModelProperty(value = "订单金额", example = "100")
    private BigDecimal orderAmount;


    @ApiModelProperty(value = "任务开始时间", example = "2023-07-26")
    private String taskStartTime;

    @ApiModelProperty(value = "任务结束时间", example = "2023-07-27")
    private String taskEndTime;

    @ApiModelProperty(value = "任务经度", example = "113.934559")
    private Double longitude;

    @ApiModelProperty(value = "任务纬度", example = "22.540366")
    private Double latitude;

    @ApiModelProperty(value = "任务详细地址", example = "任务详细地址")
    private String taskAddress;

    @ApiModelProperty(value = "冻结云享金", example = "100")
    private BigDecimal cashAmount;

    @ApiModelProperty(value = "冻结佣金（相当是冻结余额）", example = "200")
    private BigDecimal salaryAmount;

    @ApiModelProperty(value = "冻结微信", example = "200")
    private BigDecimal weChat;

    @ApiModelProperty(value = "抢单冻结云享金", example = "200")
    private BigDecimal preemptCashAmount;

    @ApiModelProperty(value = "抢单冻结余额", example = "200")
    private BigDecimal preemptSalaryAmount;

    @ApiModelProperty(value = "抢单冻结微信", example = "10")
    private BigDecimal preemptWeChat;


    @ApiModelProperty(value = "订单调整后金额", example = "100")
    private BigDecimal updateOrderAmount;


    @ApiModelProperty(value = "平台收益流水", example = "流水")
    private PlatformOrderEarningsDTO orderEarningsDTO;

    @ApiModelProperty(value = "需求描述")
    private String requireDescription;


    @ApiModelProperty(value = "更新时间", example = "")
    private String updateTime;

    @ApiModelProperty(value = "状态", example = "100")
    private String orderStatus;

    @ApiModelProperty(value = "当前状态")
    private String doing;


    public ServiceOrderFormDetailsDTO buildOrderFormDetails() {
        return ServiceOrderFormDetailsDTO.builder()
                .id(this.id)
                .createTime(this.createTime)
                .serviceId(this.serviceId)
                .serviceName(this.serviceName)
                .publisherNumber(this.publisherNumber)
                .orderAmount(this.orderAmount)
                .taskStartTime(this.taskStartTime)
                .taskEndTime(this.taskEndTime)
                .taskAddress(this.taskAddress)
                .latitude(this.latitude)
                .longitude(this.longitude)
                .cashAmount(this.cashAmount)
                .salaryAmount(this.salaryAmount)
                .weChat(this.weChat)
                .preemptCashAmount(this.preemptCashAmount)
                .preemptWeChat(this.preemptWeChat)
                .preemptSalaryAmount(this.preemptSalaryAmount)
                .updateOrderAmount(this.updateOrderAmount)
                .requireDescription(this.requireDescription)
                .orderEarningsDTO(this.orderEarningsDTO)
                .createTime(this.createTime)
                .updateTime(this.updateTime)
                .orderStatus(this.orderStatus)
                .build();
    }
}
