package com.mmc.csf.release.entity.requirements;

import com.alibaba.fastjson.annotation.JSONField;
import com.mmc.csf.infomation.dto.ServiceEvaluateDTO;
import com.mmc.csf.infomation.vo.ServiceEvaluateVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @Author small
 * @Date 2023/8/18 22:08
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class ServiceEvaluateDO {
    @ApiModelProperty(value = "id", example = "1")
    private Integer id;

    @ApiModelProperty(value = "需求id", example = "83")
    private Integer requirementsInfoId;

    @ApiModelProperty(value = "完成任务的用户", example = "1", hidden = true)
    private Integer userAccountId;

    @ApiModelProperty(value = "评价内容", example = "1")
    private String evaluationContent;

    @ApiModelProperty(value = "星级", example = "星")
    private String starLevel;

    @ApiModelProperty(value = "评价图片", example = "星")
    private String evaluationUrl;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    public ServiceEvaluateDO(ServiceEvaluateVO evaluateVO) {
        this.requirementsInfoId = evaluateVO.getRequirementsInfoId();
        this.userAccountId = evaluateVO.getUserAccountId();
        this.evaluationContent = evaluateVO.getEvaluationContent();
        this.starLevel = evaluateVO.getStarLevel();
        this.evaluationUrl = evaluateVO.getEvaluationUrl();

    }

    public ServiceEvaluateDTO buildServiceEvaluateDTO() {
        return ServiceEvaluateDTO.builder()
                .id(this.id)
                .requirementsInfoId(this.requirementsInfoId)
                .userAccountId(this.userAccountId)
                .starLevel(this.starLevel)
                .evaluationContent(this.evaluationContent)
                .evaluationUrl(this.evaluationUrl)
                .createTime(this.createTime)
                .updateTime(this.updateTime)
                .build();
    }
}
