package com.mmc.csf.release.dao;

import com.mmc.csf.infomation.dto.*;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.qo.MyPreemptQO;
import com.mmc.csf.infomation.qo.MyPublishQO;
import com.mmc.csf.infomation.vo.ServiceSettleAccountsVO;
import com.mmc.csf.release.entity.requirements.*;
import org.apache.ibatis.annotations.Mapper;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/18 14:27
 */
@Mapper
public interface RequirementsDao {
    /**
     * 需求类型列表
     *
     * @return
     */
    List<RequirementsTypeDO> listType();

    /**
     * 添加需求
     *
     * @param requirementsInfoDO
     */
    void addRequirementsInfo(RequirementsInfoDO requirementsInfoDO);

    /**
     * 获取需求
     *
     * @param requirementsInfoId
     */
    RequirementsInfoDO getRequirementsInfoById(Integer requirementsInfoId);

    /**
     * 解决需求
     *
     * @param requirementsInfoId
     */
    void solveRequire(Integer requirementsInfoId);

    /**
     * 需求发布的数量
     *
     * @param industryCaseQO
     * @return
     */
    int countListPublishPage(IndustryCaseQO industryCaseQO);

    /**
     * 需求发布列表
     *
     * @param industryCaseQO
     * @return
     */
    List<RequirementsInfoDO> listPublishPage(IndustryCaseQO industryCaseQO);

    /**
     * 删除需求
     *
     * @param requirementsInfoId
     */
    void removeRequire(Integer requirementsInfoId);

    List<RequirementsTypeDO> listTypeReq(Integer id);

    Integer findPublish(RequirementsInfoDO requirementsInfoDO);

    void updatePublish(RequirementsInfoDO requirementsInfoDO);

    Integer findPublishCount(Integer id, Integer userAccountId);

    void requirementsDao(Integer id);

    List<RequirementsInfoDO> appPublishList();

    RequirementsInfoDO detailPublish(Integer id);

    void addPublishService(ServiceRequirementsDO requirementsInfoDO);

    ServiceRequirementsDO grabTheOrder(Integer requirementsInfoId);

    void updateGrabTheOrder(Integer requirementsInfoId, Integer repertory);

    void insertService(RequirementsServiceDO requirementsServiceDO);

    void arriveAtTheScene(ServiceArriveSceneDO serviceArriveSceneDO);

    void updateScene(Integer requirementsInfoId, Integer serviceFlowId);

    ServiceArriveSceneDO arriveAtTheSceneDetails(Integer requirementsInfoId, Integer userAccountId);

    void fulfilATask(ServiceFulfilATaskDO serviceFulfilATaskDO);


    ServiceFulfilATaskDO fulfilATaskDetails(Integer requirementsInfoId, Integer userAccountId);

    void settleAccounts(ServiceSettleAccountsDO settleAccountsDO);

    ServiceSettleAccountsDO settleAccountsDetails(Integer requirementsInfoId, Integer userAccountId);

    void evaluate(ServiceEvaluateDO serviceEvaluateDO);


    ServiceEvaluateDO evaluateDetails(Integer requirementsInfoId, Integer userAccountId);

    List<RequirementsInfoDO> myPublish(MyPublishQO param);

    List<RequirementsInfoDO> myPreempt(MyPreemptQO param);

    RequirementsServiceDO droneFlyerCancel(Integer requirementsInfoId, Integer userAccountId);

    RequirementsInfoDO publisherCancel(Integer requirementsInfoId, Integer userAccountId);

    RequirementsInfoDO publisherOrderNumber(String publisherNumber);

    List<FlowDictionaryDO> flowDictionary();

    void addAmount(RequirementsAmountDO requirementsAmountDO);


    void updateInfo(Integer requirementsInfoId, Integer serviceFlowId);

    void updateFlow(Integer requirementsInfoId, Integer serviceFlowId);

    int myPublishcount(MyPublishQO param);

    int myPreemptCount(MyPreemptQO param);

    List<RequirementsInfoDO> orderRequirements(String format);

    void updateServiceAmount(Integer id);

    void InsertRequirementsAmountLog(RequirementsInfoDO requirementsInfoDO);

    void updateAmount(RequirementsAmountDO amountDO);

    void updateRequirementsInfo(RequirementsInfoDO infoDO);

    RequirementsServiceDTO requirementsServiceDTO(Integer requirementsInfoId);

    ServiceArriveSceneDTO serviceArriveSceneDTO(Integer requirementsInfoId);

    ServiceFulfilATaskDTO serviceFulfilATaskDTO(Integer requirementsInfoId);

    ServiceSettleAccountsDTO settleAccountsDTO(Integer requirementsInfoId);

    ServiceEvaluateDTO serviceEvaluateDTO(Integer requirementsInfoId);

    RequirementsInfoDO selectSettleAccounts(ServiceSettleAccountsVO settleAccountsVO);

    RequirementsInfoDO flyHandAgree(Integer requirementsInfoId);

    RequirementsServiceDO serviceSettleAccounts(ServiceSettleAccountsVO settleAccountsVO);

    void deletePublishService(Integer requirementsInfoId);

    Integer selectDeletePreempt(Integer requirementsInfoId, Integer userAccountId);


    void deletePreempt(Integer requirementsInfoId);

    void requirementsAmountUpdate(RequirementsAmountUpdateDO amountUpdateDO);

    RequirementsAmountUpdateDO selectAmountUpdate(Integer requirementsInfoId);

    RequirementsAmountUpdateDTO amountUpdateDTO(Integer requirementsInfoId);

    void insertPlatformOrderEarnings(BigDecimal earnings, Integer requirementsInfoId, Integer userAccountId);

    void updateRequirementsAmount(RequirementsInfoDO requirementsInfoDO);

    void updateAmounts(RequirementsServiceDO requirementsServiceDO);
}
