package com.mmc.csf.infomation.qo;

import com.mmc.csf.release.model.group.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;


@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class IndustryNewsQO implements Serializable {

    private static final long serialVersionUID = -46151544725013257L;

    @ApiModelProperty(value = "新闻标题",example = "新闻标题")
    private String newsTitle;

    @ApiModelProperty(value = "开始时间")
    private Date startTime;

    @ApiModelProperty(value = "结束时间")
    private Date endTime;

    @ApiModelProperty(value = "页码", required = true)
    @NotNull(message = "页码不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(message = "每页显示数不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
