package com.mmc.csf.infomation.vo;

import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;

/**
 * @Author small
 * @Date 2023/8/18 18:28
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class ServiceArriveSceneVO {
    @ApiModelProperty(value = "id")
    @NotNull(message = "id不能为空", groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "id", example = "23.344324")
    private Double longitude;

    @ApiModelProperty(value = "id", example = "44.344324")
    private Double latitude;

    @ApiModelProperty(value = "现场地址", example = "广东省深圳市")
    private String sceneAddress;

    @ApiModelProperty(value = "现场地址的url", required = true, example = "http://")
    private String sceneUrl;

    @ApiModelProperty(value = "现场用户id", hidden = true, example = "173")
    private Integer userAccountId;

    @ApiModelProperty(value = "服务需求id", required = true, example = "83")
    private Integer requirementsInfoId;


}
