package com.mmc.csf.release.entity.forum;

import java.io.Serializable;
import java.math.BigDecimal;

import com.mmc.csf.release.entity.common.BaseDO;
import com.mmc.csf.release.forum.dto.DynamicInfoDTO;
import com.mmc.csf.release.forum.vo.DynamicVO;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * 动态信息表(ForumDynamicDO)实体类
 *
 * @author lw
 * @since 2023-05-16 09:50:39
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class ForumDynamicDO extends BaseDO implements Serializable {
  private static final long serialVersionUID = 570379773690905364L;
  /** 版本字段 */
  private Integer version;
  /** 发布用户ID */
  private Integer userAccountId;
  /** 动态描述 */
  private String description;
  /** 发布动态具体位置 */
  private String location;
  /** 发布动态纬度 */
  private BigDecimal lat;
  /** 发布动态经度 */
  private BigDecimal lon;
  /** 点赞数 */
  private Integer likesCount;
  /** 评论数 */
  private Integer commentsCount;
  /** 记录父节点id */
  private String rootPath;

  public ForumDynamicDO(DynamicVO dynamicVO) {
    this.description = dynamicVO.getDescription();
    this.location = dynamicVO.getLocation();
    this.lat = dynamicVO.getLat();
    this.lon = dynamicVO.getLon();
  }

  public DynamicVO buildDynamicVO() {
    return DynamicVO.builder()
        .id(this.getId())
        .userAccountId(userAccountId)
        .description(description)
        .commentCount(commentsCount)
        .likesCount(likesCount)
        .lat(lat)
        .lon(lon)
        .location(location)
        .dynamicPublishTime(this.getCreateTime())
        .build();
  }

  public DynamicInfoDTO buildDynamicInfoDTO() {
    return DynamicInfoDTO.builder()
        .id(this.getId())
        .userAccountId(userAccountId)
        .description(description)
        .show(this.getDeleted())
        .build();
  }

  public void defaultInfo() {
    this.lon = null;
    this.lat = null;
    this.location = null;
  }
}
