package com.mmc.csf.release.entity;

import com.mmc.csf.infomation.dto.AppTenderInfoDTO;
import com.mmc.csf.infomation.dto.TenderInfoDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * author:zhenjie
 * Date:2022/5/21
 * time:16:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class TenderInfoDO implements Serializable {
    private static final long serialVersionUID = 6547272373224463237L;
    private Integer id;
    private Integer tenderNewsId;
    private String tenderInfoNo;
    private String tenderTitle;
    @ApiModelProperty(value = "招标快讯内容")
    private String tenderContent;
    private BigDecimal tenderPrice;
    private Integer deleted;
    private Date createTime;
    private Date updateTime;

    public TenderInfoDTO buildTenderInfoDTO(){
        return TenderInfoDTO.builder().id(this.id).tenderNewsId(this.tenderNewsId).tenderInfoNo(this.tenderInfoNo).tenderTitle(this.tenderTitle)
                .tenderPrice(this.tenderPrice).createTime(this.createTime).tenderContent(this.tenderContent).build();
    }

    public AppTenderInfoDTO buildAppTenderInfoDTO(){
        return AppTenderInfoDTO.builder().id(this.id).tenderNewsId(this.tenderNewsId).tenderInfoNo(this.tenderInfoNo).tenderContent(this.tenderTitle)
                .tenderPrice(this.tenderPrice).createTime(this.createTime).apply(0).build();
    }
}
