package com.mmc.csf.release.entity;

import com.mmc.csf.release.flyer.vo.FlightSkillsVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author LW
 * @date 2023/5/15 17:42
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class FlightSkillsDO implements Serializable {
    private static final long serialVersionUID = -6326079527453519916L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "pid")
    private Integer pid;
    @ApiModelProperty(value = "行业认证名称")
    private String skillsName;
    @ApiModelProperty(value = "子技能")
    private List<FlightSkillsDO> childrenSkills;

    public FlightSkillsVO buildFlightSkillsVO() {
        return FlightSkillsVO.builder().id(this.id).skillsName(this.skillsName).flightSkills(this.childrenSkills == null ? null : this.childrenSkills.stream().map(FlightSkillsDO::buildFlightSkillsVO).collect(Collectors.toList())).build();
    }
}
