package com.mmc.csf.infomation.vo;

import com.mmc.csf.release.model.group.Create;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author MMC_hzj
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TenderApplyVO implements Serializable {
    private static final long serialVersionUID = -5519324350926972959L;
    @ApiModelProperty(value = "招标id")
    @NotNull(message = "招标id不能为空", groups = {Create.class})
    private Integer tenderNewsId;
    @ApiModelProperty(value = "用户id",hidden = true)
    //@NotNull(message = "用户id不能为空", groups = {Create.class})
    private Integer userAccountId;
    @ApiModelProperty(value = "招标详情id")
    @NotNull(message = "招标详情id不能为空", groups = {Create.class})
    private Integer tenderInfoId;
    @ApiModelProperty(value = "昵称", hidden = true)
    private String nickName;
    @ApiModelProperty(value = "用户名", hidden = true)
    private String userName;
    @ApiModelProperty(value = "联系电话", hidden = true)
    //@NotNull(message = "联系电话不能为空", groups = {Create.class})
    private String phoneNum;
}
