package com.mmc.csf.release.service;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.dto.*;
import com.mmc.csf.infomation.qo.*;
import com.mmc.csf.infomation.vo.*;
import com.mmc.csf.release.entity.information.PersonSendOrderDO;
import com.mmc.csf.release.entity.requirements.ServiceRequirementsDO;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/5/18 14:29
 */
public interface RequirementsService {
    /**
     * 需求类型列表
     *
     * @return
     */
    ResultBody listType(Integer id);

    /**
     * 需求发布
     *
     * @param requirementsInfoVO
     * @param request
     * @return
     */
    ResultBody publish(RequirementsInfoVO requirementsInfoVO, HttpServletRequest request);

    /**
     * 解决需求
     *
     * @param requirementsInfoId
     * @param userAccountId
     * @return
     */
    ResultBody solveRequire(Integer requirementsInfoId, Integer userAccountId);

    /**
     * 需求发布列表
     *
     * @param industryCaseQO
     * @param request
     * @return
     */
    ResultBody listPublishPage(IndustryCaseQO industryCaseQO, HttpServletRequest request);

    /**
     * 删除需求
     *
     * @param requirementsInfoId
     * @param userAccountId
     * @return
     */
    ResultBody deleteRequire(Integer requirementsInfoId, Integer userAccountId);

    ResultBody updatePublish(RequirementsInfoVO requirementsInfoVO, HttpServletRequest request);

    ResultBody deletePublish(Integer id, Integer userAccountId);

    ResultBody appPublishList(RequirementsInfoQO requirementsInfoQO);

    ResultBody detailPublish(Integer id, HttpServletRequest request, Integer userAccountId);

    ResultBody backDetailPublish(Integer id, HttpServletRequest request, Integer userAccountId);

    ResultBody publishService(ServiceRequirementsVO serviceRequirementsVO, HttpServletRequest request);

    PageResult myPublish(Integer userAccountId, MyPublishQO param);

    ResultBody<RequirementsInfoVO> grabTheOrder(GrabTheOrderVO grabTheOrderVO, HttpServletRequest request);

    ResultBody arriveAtTheScene(ServiceArriveSceneVO serviceArriveSceneVO);

    ResultBody<ServiceArriveSceneDTO> arriveAtTheSceneDetails(Integer requirementsInfoId, Integer userAccountId);

    ResultBody fulfilATask(ServiceFulfilATaskVO fulfilATaskVO);

    ResultBody<ServiceFulfilATaskDTO> fulfilATaskDetails(Integer requirementsInfoId, Integer userAccountId);

    ResultBody settleAccounts(ServiceSettleAccountsVO settleAccountsVO, HttpServletRequest request);


    ResultBody<ServiceSettleAccountsDTO> settleAccountsDetails(Integer requirementsInfoId, Integer userAccountId);

    ResultBody evaluate(ServiceEvaluateVO evaluateVO);

    ResultBody evaluateDetails(Integer requirementsInfoId, Integer userAccountId);

    ResultBody publisherNumber(GetOrderNumberVO getOrderNumberVO, HttpServletRequest request);

    ResultBody updatePublisherNumber(GetOrderNumberUpdateVO getOrderNumberUpdateVO, HttpServletRequest request);

    ResultBody updateAmountGetNumber(UpdateAmountGetNumberVO getNumberVO, HttpServletRequest request);

    PageResult myPreempt(Integer userAccountId, MyPreemptQO param);

    ResultBody droneFlyerCancel(Integer requirementsInfoId, Integer userAccountId, HttpServletRequest request);

    ResultBody publisherCancel(Integer requirementsInfoId, Integer userAccountId, HttpServletRequest request);

    ResultBody cancelAll(LiabilityProblemVO liabilityProblemVO, Integer userAccountId,HttpServletRequest request);


    ResultBody updatePublisherCancel(RequirementsAmountVO amountVO, HttpServletRequest request);

    ResultBody<FlowDictionaryDTO> flowDictionary();

    ResultBody confirmSettlement(Integer userAccountId, Integer requirementsInfoId,HttpServletRequest request);

    ResultBody orderRequirements(String format);

    ResultBody updateServicePublish(ServiceRequirementsEditVO requirementsInfoVO, HttpServletRequest request);

    ResultBody<FlowDictionaryAndTimeDTO> flowDictionaryAndTime(Integer requirementsInfoId);

    ResultBody deletePublishService(Integer requirementsInfoId, Integer userAccountId);

    ResultBody deletePreempt(Integer requirementsInfoId, Integer userAccountId);

    ResultBody flyHandAgree(FlyHandAgreeVO agreeVO, HttpServletRequest request);

    ServiceRequirementsDO getRepertory(GrabTheOrderVO grabTheOrderVO, HttpServletRequest request);


    /**
     * 根据父订单的id找到所有子订单信息
     * @param userAccountId 发单人的id
     * @param param 条件 父id在里面
     * @return {@link PageResult}
     */
    PageResult selectRequireSonInfo(Integer userAccountId, MyPublishQO param);

    /**
     * 同意或者拒绝飞手接单
     * @param param 参数
     * @return {@link ResultBody}
     */
    ResultBody agreeOrRefusePilot(AgreeOrRefusePilotQO param);

    /**
     * 根据飞手进行派单操作
     */
    ResultBody personSendOrder(PersonSendOrderVO personSendOrderVO,String token);

    /**
     * 飞手确认接单
     */
    ResultBody orderConfirmationByPilot(Integer id,Integer status);

    /**
     * 个人飞手派单的订单列表
     */
    PageResult mySendOderList(Integer userAccountId, MyPreemptQO param);

}
