package com.mmc.csf.release.service.licence.impl;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.common.util.web.ResultEnum;
import com.mmc.csf.licence.dto.LicenseOrganizationsDTO;
import com.mmc.csf.licence.dto.LicenseTrainingProgramsDTO;
import com.mmc.csf.licence.qo.LicenseOrganizationsQO;
import com.mmc.csf.licence.vo.LicenseOrganizationsVO;
import com.mmc.csf.licence.vo.LicenseTrainingProgramsVO;
import com.mmc.csf.release.auth.dto.LoginSuccessDTO;
import com.mmc.csf.release.dao.licence.LicenceBackgroundDao;
import com.mmc.csf.release.entity.licence.LicenseOrganizationsDO;
import com.mmc.csf.release.entity.licence.LicenseProgramsDO;
import com.mmc.csf.release.entity.licence.LicenseTrainingProgramsDO;
import com.mmc.csf.release.service.licence.LicenceBackgroundService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author small
 * @Date 2023/7/13 16:01
 * @Version 1.0
 */
@Service
@Slf4j
public class LicenceBackgroundServiceImpl implements LicenceBackgroundService {

    @Autowired
    private LicenceBackgroundDao licenceBackgroundDao;

    @Override
    public ResultBody insertOrganizations(LicenseOrganizationsVO organizations, LoginSuccessDTO userLoginInfoFromRedis) {
        int count = licenceBackgroundDao.countOrg(organizations.getName());
        if (count > 0) {
            return ResultBody.error(ResultEnum.THE_ORGANIZATION_NAME_ALREADY_EXISTS);
        }
        getOrgName(organizations);
        LicenseOrganizationsDO organizationsDO = new LicenseOrganizationsDO(organizations);
        List<Integer> list = new ArrayList<>();
        LicenseTrainingProgramsDO programsDO = null;
        if (organizations.getTrainingProgramsVOS() != null && organizations.getTrainingProgramsVOS().size() != 0) {
            HashMap<LicenseTrainingProgramsVO, Integer> hashMap = new HashMap<>();
            licenceBackgroundDao.insertOrganizations(organizationsDO);
            for (LicenseTrainingProgramsVO trainingProgramsVO : organizations.getTrainingProgramsVOS()) {
                Integer pro = hashMap.get(trainingProgramsVO);
                if (pro == null) {
                    hashMap.put(trainingProgramsVO, 1);
                    programsDO = new LicenseTrainingProgramsDO(trainingProgramsVO);
                    Integer id = organizationsDO.getId();
                    programsDO.setOrgId(id);
                    licenceBackgroundDao.insertProject(programsDO);
                    list.add(programsDO.getId());
                    organizationsDO.setOrgTrainingIds(list);
                } else {
                    licenceBackgroundDao.removeProject(programsDO.getId());
                    licenceBackgroundDao.removeOrg(organizationsDO.getId());
                    hashMap.put(trainingProgramsVO, pro++);
                    return ResultBody.error(ResultEnum.THREE_FIELDS_CAN_BE_REPEATED);
                }
            }
          //  licenceBackgroundDao.insertLicenseOrgTraining(organizationsDO.getOrgTrainingIds(), organizationsDO.getId());
        }
        if (organizations.getTrainingProgramsVOS()==null || organizations.getTrainingProgramsVOS().size()==0){
            licenceBackgroundDao.insertOrganizations(organizationsDO);
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody updateOrganizations(LicenseOrganizationsVO organizations, LoginSuccessDTO userLoginInfoFromRedis) {
        LicenseOrganizationsDO organizationsDO = new LicenseOrganizationsDO(organizations);
        int count = licenceBackgroundDao.countId(organizationsDO);
        if (count > 0) {
            return ResultBody.error(ResultEnum.THE_ORGANIZATION_NAME_ALREADY_EXISTS);
        }
        getOrgName(organizations);

        licenceBackgroundDao.removeOrgAndTraining(organizations.getId());
        LicenseTrainingProgramsDO programsDO = null;
        List<Integer> list = new ArrayList<>();
        if (organizations.getTrainingProgramsVOS() != null && organizations.getTrainingProgramsVOS().size() != 0) {
            HashMap<LicenseTrainingProgramsVO, Integer> hashMap = new HashMap<>();
            for (LicenseTrainingProgramsVO trainingProgramsVO : organizations.getTrainingProgramsVOS()) {
                Integer pro = hashMap.get(trainingProgramsVO);
                if (pro == null) {
                    hashMap.put(trainingProgramsVO, 1);
                } else {
                    hashMap.put(trainingProgramsVO, pro++);
                    return ResultBody.error(ResultEnum.THREE_FIELDS_CAN_BE_REPEATED);
                }
               // licenceBackgroundDao.removeOrganizations(organizations.getId());
                programsDO = new LicenseTrainingProgramsDO(trainingProgramsVO);
                Integer id = organizations.getId();
                programsDO.setOrgId(id);
                licenceBackgroundDao.insertProject(programsDO);
                list.add(programsDO.getId());
                organizationsDO.setOrgTrainingIds(list);

            }
            licenceBackgroundDao.updateOrganizations(organizationsDO);
           // licenceBackgroundDao.insertLicenseOrgTraining(organizationsDO.getOrgTrainingIds(), organizationsDO.getId());
        }
        if (organizations.getTrainingProgramsVOS()==null || organizations.getTrainingProgramsVOS().size()==0){
            licenceBackgroundDao.updateOrganizations(organizationsDO);
        }
        return ResultBody.success();
    }

    private void getOrgName(LicenseOrganizationsVO organizations) {
        String region = organizations.getRegion();
        List<String> strings = Arrays.asList(region.split(","));
        List<Integer> collect = strings.stream().map(Integer::valueOf).collect(Collectors.toList());
        List<String> orgName = licenceBackgroundDao.getOrgName(collect);
        String join = StringUtils.join(orgName, ",");
        organizations.setRegionName(join);
    }

    @Override
    public ResultBody removeOrganizations(Integer id) {
        licenceBackgroundDao.removeOrg(id);
        licenceBackgroundDao.removeOrgAndTraining(id);
        return ResultBody.success();
    }

    @Override
    public PageResult listOrgPage(LicenseOrganizationsQO organizationsQO, LoginSuccessDTO userLoginInfoFromRedis) {
        int count = licenceBackgroundDao.countListOrgPage(organizationsQO);
        if (count == 0) {
            return PageResult.buildPage(organizationsQO.getPageNo(), organizationsQO.getPageSize(), count);
        }
        Integer pageNo = organizationsQO.getPageNo();
        organizationsQO.buildCurrentPage();
        List<LicenseOrganizationsDO> licenseOrganizationsDOS = licenceBackgroundDao.listOrgPage(organizationsQO);
        List<LicenseOrganizationsDTO> orgList = licenseOrganizationsDOS.stream().map(t -> t.organizationsDTO()).collect(Collectors.toList());
        //培训项目数据
        List<LicenseProgramsDO> licenseProgramsDOS = licenceBackgroundDao.trainingProgram(organizationsQO);
        List<LicenseTrainingProgramsDTO> programsList = licenseProgramsDOS.stream().map(t -> t.buildTrainingProgramsDTO()).collect(Collectors.toList());
        for (LicenseOrganizationsDTO org : orgList) {
            ArrayList<LicenseTrainingProgramsDTO> list = new ArrayList<>();
            for (LicenseTrainingProgramsDTO pro : programsList) {
                if (org.getId().equals(pro.getOrgId())) {
                    list.add(pro);
                    org.setProgramsDOList(list);
                }
            }
        }
      /*  List<LicenseOrganizationsDTO> collect = orgList.stream().filter(o -> {
            if (o.getProgramsDOList() == null) {
                return false;
            }
            return true;
        }).collect(Collectors.toList());*/


        List<LicenseOrganizationsDTO> subList = orgList.stream().skip((pageNo - 1) * organizationsQO.getPageSize()).limit(organizationsQO.getPageSize()).
                collect(Collectors.toList());
        return PageResult.buildPage(pageNo, organizationsQO.getPageSize(), orgList.size(), subList);
    }


}
