package com.mmc.csf.release.entity.requirements;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.mmc.csf.infomation.vo.RequirementsInfoVO;
import com.mmc.csf.release.model.group.Insert;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/5/18 15:11
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class RequirementsInfoDO implements Serializable {
    private static final long serialVersionUID = -1811974173256250060L;
    private Integer id;
    private Integer requirementTypeId;
    private Integer userAccountId;
    private Integer provinceCode;
    private Integer cityCode;
    private Integer districtCode;
    private String publishName;
    private String publishPhone;
    private String requireDescription;
    private Integer deleted;
    //是否解决
    private Boolean solved;
    private Date createTime;
    private Date updateTime;
    @ApiModelProperty(value = "任务标题", example = "任务标题001", required = true)
    @NotBlank(message = "任务标题不能为空", groups = {Insert.class, Update.class})
    @Size(max = 15, message = "任务标题限制15个字")
    private String taskTitle;

    @ApiModelProperty(value = "任务开始时间", example = "2023-07-25", required = true)
    @NotNull(message = "任务开始时间不能为空", groups = {Insert.class, Update.class})
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date taskStartTime;

    @ApiModelProperty(value = "任务结束时间", example = "2023-07-26", required = true)
    @NotNull(message = "任务开始时间不能为空", groups = {Insert.class, Update.class})
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date taskEndTime;

    @ApiModelProperty(value = "任务地址", example = "广东省深圳市", required = true)
    @NotBlank(message = "任务地址不能为空", groups = {Insert.class, Update.class})
    private String taskAddress;


    @ApiModelProperty(value = "任务经度", example = "23.344324", required = true)
    @NotNull(message = "任务经度不能为空", groups = {Insert.class, Update.class})
    private Double longitude;

    @ApiModelProperty(value = "任务纬度", example = "44.344324", required = true)
    @NotNull(message = "任务纬度不能为空", groups = {Insert.class, Update.class})
    private Double latitude;


    @ApiModelProperty(value = "描述图片", example = "http://,http://", required = false)
    private String requireUrl;


    @ApiModelProperty(value = "类型名称")
    private String requirementTypeName;


    public RequirementsInfoVO buildRequirementsInfoVO() {
        return RequirementsInfoVO.builder().id(this.id).requirementTypeId(this.requirementTypeId).userAccountId(this.userAccountId).publishName(this.publishName)
                .publishPhone(this.publishPhone).requireDescription(this.requireDescription).solved(this.solved).taskStartTime(this.taskStartTime).taskEndTime(this.taskEndTime)
                .taskTitle(this.taskTitle)
                .taskAddress(this.taskAddress)
                .longitude(this.longitude)
                .latitude(this.latitude)
                .requirementTypeName(this.requirementTypeName)
                .requireUrl(this.requireUrl).build();
    }

    public RequirementsInfoDO(RequirementsInfoVO requirementsInfoVO) {
        this.id = requirementsInfoVO.getId();
        this.requirementTypeId = requirementsInfoVO.getRequirementTypeId();
        this.userAccountId = requirementsInfoVO.getUserAccountId();
        this.publishName = requirementsInfoVO.getPublishName();
        this.publishPhone = requirementsInfoVO.getPublishPhone();
        this.requireDescription = requirementsInfoVO.getRequireDescription();
        this.provinceCode = requirementsInfoVO.getProvinceCode();
        this.cityCode = requirementsInfoVO.getCityCode();
        this.districtCode = requirementsInfoVO.getDistrictCode();
        this.taskStartTime = requirementsInfoVO.getTaskStartTime();
        this.taskEndTime = requirementsInfoVO.getTaskEndTime();
        this.taskTitle = requirementsInfoVO.getTaskTitle();
        this.taskAddress = requirementsInfoVO.getTaskAddress();
        this.longitude = requirementsInfoVO.getLongitude();
        this.latitude = requirementsInfoVO.getLatitude();
        this.requireUrl = requirementsInfoVO.getRequireUrl();
    }

}
