package com.mmc.csf.release.entity.licence;

import com.mmc.csf.licence.dto.LicenseTrainingProgramsDTO;
import com.mmc.csf.release.model.group.Create;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/7/14 13:37
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class LicenseProgramsDO {
    private static final long serialVersionUID = -5814724843819090363L;
    @ApiModelProperty(value = "培训id", example = "1")
    @NotNull(message = "培训id不能为空", groups = Update.class)
    private Integer id;

    @ApiModelProperty(value = "培训等级id", example = "1", required = true)
    @NotNull(message = "培训等级id不能为空", groups = {Create.class, Update.class})
    private Integer gradeId;

    @ApiModelProperty(value = "培训等级名称", example = "1", required = true)
    @NotNull(message = "培训等级名称不能为空", groups = {Create.class, Update.class})
    private String gradeName;

    @ApiModelProperty(value = "培训机型id", example = "1", required = true)
    @NotNull(message = "培训机型id不能为空", groups = {Create.class, Update.class})
    private Integer modelsId;

    @ApiModelProperty(value = "培训机型名称", example = "1", required = true)
    @NotNull(message = "培训机型名称不能为空", groups = {Create.class, Update.class})
    private String modelsName;

    @ApiModelProperty(value = "培训类型id", example = "1", required = true)
    @NotNull(message = "培训类型id不能为空", groups = {Create.class, Update.class})
    private Integer typeId;

    @ApiModelProperty(value = "培训类型名称", example = "1", required = true)
    @NotNull(message = "培训类型名称", groups = {Create.class, Update.class})
    private String typeName;

    @ApiModelProperty(value = "培训价格", example = "1000", required = true)
    @NotNull(message = "培训价格不能为空", groups = {Create.class, Update.class})
    @Size(min = 0, max = 100000, message = "价格不能超过100000")
    private BigDecimal price;

    @ApiModelProperty(value = "培训地点不能为空", example = "广东省深圳市南山区XXX001", required = true)
    @NotBlank(message = "培训地点不能为空", groups = {Create.class, Update.class})
    private String place;

    @ApiModelProperty(value = "培训主图不能为空", example = "http://", required = true)
    @NotBlank(message = "培训主图不能为空", groups = {Create.class, Update.class})
    private String mainImage;

    @ApiModelProperty(value = "机构id", example = "http://", required = true)
    @NotBlank(message = "机构id", groups = {Create.class, Update.class})
    private Integer orgId;


    /**
     * DTO转换
     *
     * @return
     */
    public LicenseTrainingProgramsDTO buildTrainingProgramsDTO() {
        return LicenseTrainingProgramsDTO.builder().id(this.id)
                .gradeId(this.gradeId)
                .gradeName(this.gradeName)
                .modelsId(this.modelsId)
                .modelsName(this.modelsName)
                .typeId(this.typeId)
                .typeName(this.typeName)
                .price(this.price)
                .place(this.place)
                .mainImage(this.mainImage)
                .orgId(this.orgId)
                .build();
    }
}
