package com.mmc.csf.common.util.wx;

import java.security.MessageDigest;
import java.util.Arrays;

public class WXMsgPushUtils {

    /**
     * 用SHA1算法生成安全签名
     */
    public static String getSHA1(String... values) throws Exception {

        try {
            String[] array = new String[values.length];
            for (int i = 0; i < values.length; i++) {
                array[i] = values[i];
            }

            StringBuffer sb = new StringBuffer();
            // 字符串排序
            Arrays.sort(array);
            for (int i = 0; i < values.length; i++) {
                sb.append(array[i]);
            }
            String str = sb.toString();
            // SHA1签名生成
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(str.getBytes());
            byte[] digest = md.digest();

            StringBuffer hexstr = new StringBuffer();
            String shaHex = "";
            for (int i = 0; i < digest.length; i++) {
                shaHex = Integer.toHexString(digest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexstr.append(0);
                }
                hexstr.append(shaHex);
            }
            return hexstr.toString();
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception("SHA1加密失败");
        }

    }
}