package com.mmc.csf.release.controller;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.qo.IndustryNewsQO;
import com.mmc.csf.infomation.vo.IndustryNewsDTO;
import com.mmc.csf.infomation.vo.IndustryNewsVO;
import com.mmc.csf.release.model.group.Create;
import com.mmc.csf.release.model.group.Page;
import com.mmc.csf.release.model.group.Update;
import com.mmc.csf.release.service.IndustryNewsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/5/19 10:42
 */
@Api(tags = {"行业新闻-相关接口"})
@RestController
@RequestMapping("/industry-news/")
public class IndustryNewsController extends BaseController {
    @Autowired
    private IndustryNewsService industryNewsService;

    @ApiOperation(value = "添加-行业新闻")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("insertIndustryNews")
    public ResultBody insertIndustryNews(@RequestBody @Validated(Create.class) IndustryNewsVO industryNewsVO, HttpServletRequest request){
        return industryNewsService.insertIndustryNews(industryNewsVO, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "修改-行业新闻")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("upDateIndustryNews")
    public ResultBody upDateIndustryNews(@RequestBody @Validated(Update.class) IndustryNewsVO industryNewsVO, HttpServletRequest request){
        return industryNewsService.upDateIndustryNews(industryNewsVO, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "查询-新闻详情")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = IndustryNewsDTO.class) })
    @GetMapping("details")
    public ResultBody<IndustryNewsDTO> details(@RequestParam Integer id){
        return industryNewsService.details(id);
    }

    @ApiOperation(value = "后台-新闻列表")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = IndustryNewsDTO.class) })
    @PostMapping("backgroundListNewsPage")
    public ResultBody<IndustryNewsDTO> backgroundListNewsPage(@Validated(value = {Page.class})@RequestBody IndustryNewsQO industryNewsQO, HttpServletRequest request){
        return industryNewsService.backgroundListNewsPage(industryNewsQO, request);
    }

    @ApiOperation(value = "web端-新闻列表")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = IndustryNewsDTO.class) })
    @PostMapping("listNewsPage")
    public ResultBody<IndustryNewsDTO> listNewsPage(@Validated(value = {Page.class})@RequestBody IndustryCaseQO industryCaseQO, HttpServletRequest request){
        return industryNewsService.listNewsPage(industryCaseQO, request);
    }
}
