package com.mmc.csf.release.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mmc.csf.common.util.json.JsonUtil;
import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.HttpsRequestUtil;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.common.util.web.ResultEnum;
import com.mmc.csf.config.IsNullConvertZeroUtil;
import com.mmc.csf.infomation.dto.*;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.qo.MyPreemptQO;
import com.mmc.csf.infomation.qo.MyPublishQO;
import com.mmc.csf.infomation.vo.*;
import com.mmc.csf.release.constant.*;
import com.mmc.csf.release.dao.RequirementsDao;
import com.mmc.csf.release.entity.requirements.*;
import com.mmc.csf.release.feign.PmsAppApi;
import com.mmc.csf.release.feign.UserAppApi;
import com.mmc.csf.release.industry.IndustryTypeDTO;
import com.mmc.csf.release.service.RequirementsService;
import com.mmc.csf.release.util.RestTemplateUtil;
import lombok.extern.slf4j.Slf4j;
import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import static com.mmc.csf.common.util.redis.RedisConstant.createWxToken;

/**
 * @author: zj
 * @Date: 2023/5/18 14:29
 */
@Slf4j
@Service
public class RequirementsServiceImpl implements RequirementsService {
    @Autowired
    private RequirementsDao requirementsDao;

    @Autowired
    private UserAppApi userAppApi;

    @Autowired
    private RestTemplateUtil restTemplateUtil;

    @Autowired
    private RestTemplate restTemplate;

    @Value("${iuav.omsapp.url}")
    private String omsApp;

    @Autowired
    private PmsAppApi pmsAppApi;

    @Value("${iuav.userapp.url}")
    private String userApp;

    @Value("${iuav.pmsapp.url}")
    private String pmsApp;
    @Value("${iuav.payment.url}")
    private String paymentApp;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    private UserSystemConstant userSystemConstant;

    @Override
    public ResultBody listType(Integer id) {
        List<RequirementsTypeDO> requirementsTypeDOList = requirementsDao.listTypeReq(id);
        List<RequirementsTypeVO> requirementsTypeVOList = requirementsTypeDOList.stream().map(RequirementsTypeDO::buildRequirementsTypeVO).collect(Collectors.toList());
        return ResultBody.success(requirementsTypeVOList);
    }

    @Override
    public ResultBody publish(RequirementsInfoVO requirementsInfoVO, HttpServletRequest request) {
        //是否完成认证
//        UserAccountSimpleDTO userAccountSimpleDTO = userAppApi.feignGetUserSimpleInfo(requirementsInfoVO.getUserAccountId());
//        if (userAccountSimpleDTO == null || !userAccountSimpleDTO.getCompanyAuthStatus().toString().equals("1")){
//            return ResultBody.error(ResultEnum.COMPANY_NOT_VERIFY_ERROR);
//        }

        RequirementsInfoDO requirementsInfoDO = new RequirementsInfoDO(requirementsInfoVO);
        requirementsInfoDO.setPublisherNumber(randomOrderCode());
        requirementsDao.addRequirementsInfo(requirementsInfoDO);
        return ResultBody.success();
    }

    HttpHeaders headers = new HttpHeaders();


    @Override
    public ResultBody solveRequire(Integer requirementsInfoId, Integer userAccountId) {
        RequirementsInfoDO requirementsInfoDO = requirementsDao.getRequirementsInfoById(requirementsInfoId);
        if (!requirementsInfoDO.getUserAccountId().toString().equals(userAccountId.toString())) {
            return ResultBody.error("无权限");
        }
        requirementsDao.solveRequire(requirementsInfoId);
        return ResultBody.success();
    }

    @Override
    public ResultBody listPublishPage(IndustryCaseQO industryCaseQO, HttpServletRequest request) {
        //查询对应地区的用户
        int count = requirementsDao.countListPublishPage(industryCaseQO);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(industryCaseQO.getPageNo(), industryCaseQO.getPageSize(), count));
        }
        Integer pageNo = industryCaseQO.getPageNo();
        industryCaseQO.buildCurrentPage();
        List<RequirementsInfoDO> requirementsInfoDOList = requirementsDao.listPublishPage(industryCaseQO);
        List<RequirementsInfoVO> requirementsInfoVOS = requirementsInfoDOList.stream().map(RequirementsInfoDO::buildRequirementsInfoVO).collect(Collectors.toList());
        Map<Integer, String> collect = requirementsDao.listType().stream().collect(Collectors.toMap(RequirementsTypeDO::getId, d -> d.getTypeName()));
        for (RequirementsInfoVO requirementsInfoVO : requirementsInfoVOS) {
            requirementsInfoVO.setRequirementTypeName(collect.get(requirementsInfoVO.getRequirementTypeId()));
        }
        return ResultBody.success(PageResult.buildPage(pageNo, industryCaseQO.getPageSize(), count, requirementsInfoVOS));
    }

    @Override
    public ResultBody deleteRequire(Integer requirementsInfoId, Integer userAccountId) {
        requirementsDao.removeRequire(requirementsInfoId);
        return ResultBody.success();
    }

    @Override
    public ResultBody updatePublish(RequirementsInfoVO requirementsInfoVO, HttpServletRequest request) {
        RequirementsInfoDO requirementsInfoDO = new RequirementsInfoDO(requirementsInfoVO);
        Integer publish = requirementsDao.findPublish(requirementsInfoDO);
        if (publish == 0) {
            return ResultBody.error(ResultEnum.YOU_CANNOT_MODIFY_REQUIREMENTS_PUBLISHED_BY_OTHERS);
        }
        requirementsDao.updatePublish(requirementsInfoDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody deletePublish(Integer id, Integer userAccountId) {
        Integer publish = requirementsDao.findPublishCount(id, userAccountId);
        if (publish == 0) {
            return ResultBody.error(ResultEnum.YOU_CANNOT_DELETE_REQUIREMENTS_POSTED_BY_OTHERS);
        }
        requirementsDao.requirementsDao(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody appPublishList() {
        List<RequirementsInfoDO> requirementsInfoDOS = requirementsDao.appPublishList();
        //远程调用服务一级分类
        List<IndustryTypeDTO> industryTypeDTOS = listIndustry();
        List<RequirementsInfoVO> collect = requirementsInfoDOS.stream().map(RequirementsInfoDO::buildRequirementsInfoVO).collect(Collectors.toList());
        for (RequirementsInfoVO requirementsInfoVO : collect) {
            for (IndustryTypeDTO industryTypeDTO : industryTypeDTOS) {
                if (requirementsInfoVO.getServiceId() != null && requirementsInfoVO.getServiceId().equals(industryTypeDTO.getId())) {
                    requirementsInfoVO.setServiceName(industryTypeDTO.getTypeName());
                }
            }
        }
        return ResultBody.success(collect);
    }

    @Override
    public ResultBody detailPublish(Integer id, HttpServletRequest request, Integer userAccountId) {
        RequirementsInfoDO requirementsInfoDO = requirementsDao.detailPublish(id);
        RequirementsInfoVO requirementsInfoVO = requirementsInfoDO.buildRequirementsInfoVO();
        if (userAccountId.equals(requirementsInfoVO.getUserAccountId())) {
            requirementsInfoVO.setParamMoney(BigDecimal.valueOf(0.00));
        } else if (!userAccountId.equals(requirementsInfoVO.getUserAccountId())) {
            requirementsInfoVO.setParamMoney(BigDecimal.valueOf(0.10));
        }
        requirementsInfoVO.setOrderNumber(randomOrderCode());
        requirementsInfoVO.setPublishAccountId(requirementsInfoDO.getUserAccountId());
        requirementsInfoVO.setRequirementsInfoId(requirementsInfoDO.getId());
        //IndustryTypeDTO industryTypeDTO = pmsAppApi.feignQquerygetIndustryTypeById(requirementsInfoVO.getServiceId());
        IndustryTypeDTO industryTypeDTO = getIndustryTypeById(requirementsInfoVO.getServiceId());
        requirementsInfoVO.setServiceName(industryTypeDTO.getTypeName());
        //已经支付
        String s = stringRedisTemplate.opsForValue().get(requirementsInfoDO.getId().toString());
        RequirementsInfoVO orderVO = JSON.parseObject(s, RequirementsInfoVO.class);
        if (s != null) {
            if (requirementsInfoDO.getId().equals(orderVO.getRequirementsInfoId()) && userAccountId.equals(orderVO.getUserAccountId())) {
                requirementsInfoVO.setParamMoney(new BigDecimal(0));
                requirementsInfoVO.setOrderNumber(orderVO.getOrderNumber());
                requirementsInfoVO.setPublishPhone("");
                return ResultBody.success(requirementsInfoVO);
            }
        }
        //生成
        ResultBody resultBody = releaseOrder(requirementsInfoVO, request.getHeader("token"));
        if (resultBody.getCode().equals(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED.getResultCode())) {
            return resultBody;
        }
        if (requirementsInfoVO.getPublish() == 0) {
            requirementsInfoVO.setPublishPhone("");
        }
        return ResultBody.success(requirementsInfoVO);
    }


    @Override
    public ResultBody backDetailPublish(Integer id, HttpServletRequest request, Integer userAccountId) {
        RequirementsInfoDO requirementsInfoDO = requirementsDao.detailPublish(id);
        RequirementsInfoVO requirementsInfoVO = requirementsInfoDO.buildRequirementsInfoVO();
        if (userAccountId.equals(requirementsInfoVO.getUserAccountId())) {
            requirementsInfoVO.setParamMoney(BigDecimal.valueOf(0.00));
        } else if (!userAccountId.equals(requirementsInfoVO.getUserAccountId())) {
            requirementsInfoVO.setParamMoney(BigDecimal.valueOf(0.10));
        }
        requirementsInfoVO.setOrderNumber(randomOrderCode());
        requirementsInfoVO.setPublishAccountId(requirementsInfoDO.getUserAccountId());
        requirementsInfoVO.setRequirementsInfoId(requirementsInfoDO.getId());

        //已经支付
        String s = stringRedisTemplate.opsForValue().get(requirementsInfoDO.getId().toString());
        RequirementsInfoVO orderVO = JSON.parseObject(s, RequirementsInfoVO.class);
        if (s != null) {
            if (requirementsInfoDO.getId().equals(orderVO.getRequirementsInfoId()) && userAccountId.equals(orderVO.getUserAccountId())) {
                requirementsInfoVO.setParamMoney(new BigDecimal(0));
                requirementsInfoVO.setOrderNumber(orderVO.getOrderNumber());
                requirementsInfoVO.setPublishPhone("");
                return ResultBody.success(requirementsInfoVO);
            }
        }

        //生成
        ResultBody resultBody = releaseOrder(requirementsInfoVO, request.getHeader("token"));
        if (resultBody.getCode().equals(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED.getResultCode())) {
            return resultBody;
        }
        requirementsInfoVO.setPublishPhone("");
        return ResultBody.success(requirementsInfoVO);
    }

    @Override
    public ResultBody<GetOrderNumberDTO> publisherNumber(GetOrderNumberVO getOrderNumberVO, HttpServletRequest request) {
        PublisherWalletFlowVO publisherWalletFlowVO = new PublisherWalletFlowVO();

        ServiceRequirementsDO requirementsInfoDO = new ServiceRequirementsDO();
        IsNullConvertZeroUtil.checkIsNull(requirementsInfoDO);
        IsNullConvertZeroUtil.checkIsNull(publisherWalletFlowVO);
        IsNullConvertZeroUtil.checkIsNull(publisherWalletFlowVO);
        //用户钱包信息接口
        ResultBody resultBody = getCurrentUserPayWalletInfo(request);
        GetOrderNumberDTO orderNumberDTO = new GetOrderNumberDTO();
        orderNumberDTO.setUserAccountId(getOrderNumberVO.getUserAccountId());
        PayWalletDTO payWalletDTO = (PayWalletDTO) resultBody.getResult();
        //用户云享金+用户佣金>总金额
        //剩余后台云享金
        BigDecimal cashAmt = payWalletDTO.getCashAmt();
        //剩余佣金
        BigDecimal salaryAmt = payWalletDTO.getSalaryAmt();
        //用户云享金加上佣金的总金额
        BigDecimal cashAndSalary = cashAmt.add(salaryAmt);
        //需要支付的总金额
        BigDecimal totalAmount = getOrderNumberVO.getOrderAmount().add(OrderLevelEnum.match(getOrderNumberVO.getOrderLevelEnum().getKey()).getValue());
        BigDecimal rushAndTop = OrderLevelEnum.match(getOrderNumberVO.getOrderLevelEnum().getKey()).getValue();
        String orderLevelEnum = OrderLevelEnum.match(getOrderNumberVO.getOrderLevelEnum().getKey()).getKey();
        //需要支付的总金额
        BigDecimal orderAmount = getOrderNumberVO.getOrderAmount();
        String paymentType = getOrderNumberVO.getPaymentType();
        String[] split = paymentType.split(",");
        Set<String> collect = Arrays.asList(split).stream().collect(Collectors.toSet());
        TreeSet<String> objects = new TreeSet<>(collect);
        //用户剩余的佣金
        BigDecimal userSalaryAmt = new BigDecimal(0);
        //云享金余额还剩余多少
        BigDecimal userCashAmt = new BigDecimal(0);
        BigDecimal tempTotalAmount = new BigDecimal(0);
        //存在置顶或加急
        if (rushAndTop.compareTo(BigDecimal.ZERO) != 0) {
            tempTotalAmount = rushAndTop;
            for (String type : objects) {
                switch (type) {
                    case "1":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (cashAmt.compareTo(tempTotalAmount) == 1 || cashAmt.compareTo(tempTotalAmount) == 0) {
                                // walletFlowVO.setCashAmount(tempTotalAmount);
                                //加急云享金支付
                                if (orderLevelEnum.equals("RUSH_ORDER")) {
                                    publisherWalletFlowVO.setUrgentYxjAmount(tempTotalAmount);
                                    requirementsInfoDO.setLevelCashAmount(tempTotalAmount);
                                } else if (orderLevelEnum.equals("TOP_ORDER")) {
                                    publisherWalletFlowVO.setTopYxjAmount(cashAmt);
                                    requirementsInfoDO.setLevelCashAmount(tempTotalAmount);
                                }
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(cashAmt);
                                // walletFlowVO.setCashAmount(cashAmt);
                                if (orderLevelEnum.equals("RUSH_ORDER")) {
                                    publisherWalletFlowVO.setUrgentYxjAmount(cashAmt);
                                    requirementsInfoDO.setLevelCashAmount(cashAmt);
                                } else if (orderLevelEnum.equals("TOP_ORDER")) {
                                    System.out.println(cashAmt);

                                    publisherWalletFlowVO.setTopYxjAmount(cashAmt);
                                    requirementsInfoDO.setLevelCashAmount(cashAmt);
                                }
                            }
                        }
                        break;
                    case "2":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (salaryAmt.compareTo(tempTotalAmount) == 1 || salaryAmt.compareTo(tempTotalAmount) == 0) {
                                //  walletFlowVO.setSalaryAmount(tempTotalAmount);
                                publisherWalletFlowVO.setTopSalaryAmount(tempTotalAmount);
                                if (orderLevelEnum.equals("RUSH_ORDER")) {
                                    publisherWalletFlowVO.setUrgentSalaryAmount(tempTotalAmount);
                                    requirementsInfoDO.setLevelSalaryAmount(tempTotalAmount);
                                } else if (orderLevelEnum.equals("TOP_ORDER")) {
                                    publisherWalletFlowVO.setTopSalaryAmount(tempTotalAmount);
                                    requirementsInfoDO.setLevelSalaryAmount(tempTotalAmount);
                                }

                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(salaryAmt);
                                // walletFlowVO.setSalaryAmount(salaryAmt);
                                publisherWalletFlowVO.setTopSalaryAmount(salaryAmt);
                                requirementsInfoDO.setLevelSalaryAmount(salaryAmt);
                                if (orderLevelEnum.equals("RUSH_ORDER")) {
                                    publisherWalletFlowVO.setUrgentSalaryAmount(salaryAmt);
                                } else if (orderLevelEnum.equals("TOP_ORDER")) {
                                    publisherWalletFlowVO.setTopSalaryAmount(salaryAmt);
                                    requirementsInfoDO.setLevelSalaryAmount(salaryAmt);
                                }
                            }
                        }

                        break;
                    case "3":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            //需要支付微信
                            requirementsInfoDO.setLevelWeChatAmount(tempTotalAmount);
                            // walletFlowVO.setWeChat(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        }
                        break;
                    default:
                        break;
                }
            }

            System.out.println(requirementsInfoDO);
            System.out.println(publisherWalletFlowVO);

            if (orderLevelEnum.equals("RUSH_ORDER")) {
                //加急的云享金
                BigDecimal urgentYxjAmount = publisherWalletFlowVO.getUrgentYxjAmount();
                userCashAmt = cashAmt.subtract(urgentYxjAmount);
                BigDecimal urgentSalaryAmount = publisherWalletFlowVO.getUrgentSalaryAmount();
                userSalaryAmt = salaryAmt.subtract(urgentSalaryAmount);

            } else if (orderLevelEnum.equals("TOP_ORDER")) {
                //置顶的云享金
                BigDecimal topYxjAmount = publisherWalletFlowVO.getTopYxjAmount();
                userCashAmt = cashAmt.subtract(topYxjAmount);
                BigDecimal topSalaryAmount = publisherWalletFlowVO.getTopSalaryAmount();
                userSalaryAmt = salaryAmt.subtract(topSalaryAmount);
            }
            tempTotalAmount = orderAmount;
            //剩下的用于支付任务佣金
            for (String type : objects) {
                switch (type) {
                    case "1":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (userCashAmt.compareTo(tempTotalAmount) == 1 || userCashAmt.compareTo(tempTotalAmount) == 0) {
                                // walletFlowVO.setCashAmount(tempTotalAmount);
                                publisherWalletFlowVO.setCashAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(userCashAmt);
                                publisherWalletFlowVO.setCashAmount(userCashAmt);
                            }
                        }
                        break;
                    case "2":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (userSalaryAmt.compareTo(tempTotalAmount) == 1 || userSalaryAmt.compareTo(tempTotalAmount) == 0) {
                                publisherWalletFlowVO.setSalaryAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(userSalaryAmt);
                                publisherWalletFlowVO.setSalaryAmount(userSalaryAmt);
                            }
                        }

                        break;
                    case "3":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            // publisherWalletFlowVO.setWeChat(tempTotalAmount);
                            requirementsInfoDO.setWeChat(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        }
                        break;
                    default:
                        break;
                }
            }
        }
        //不存在加急或者置顶
        if (rushAndTop.compareTo(BigDecimal.ZERO) == 0) {
            if (getOrderNumberVO.getOrderMode() == 2) {
                Integer requirementsInfoId = getOrderNumberVO.getRequirementsInfoId();
                RequirementsInfoDO requirementsInfoDO1 = requirementsDao.detailPublish(requirementsInfoId);
                BigDecimal orderAmount1 = requirementsInfoDO1.getOrderAmount();
                BigDecimal bigDecimal = new BigDecimal(0.3);
                tempTotalAmount = orderAmount1.multiply(bigDecimal).setScale(2, BigDecimal.ROUND_HALF_UP);
            } else if (getOrderNumberVO.getOrderMode() == 1) {
                tempTotalAmount = orderAmount;
            }
            for (String type : objects) {
                switch (type) {
                    case "1":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (cashAmt.compareTo(tempTotalAmount) == 1 || cashAmt.compareTo(tempTotalAmount) == 0) {
                                publisherWalletFlowVO.setCashAmount(tempTotalAmount);
                                // walletFlowVO.setCashAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(cashAmt);
                                publisherWalletFlowVO.setCashAmount(cashAmt);
                                //  walletFlowVO.setCashAmount(cashAmt);
                            }
                        }
                        break;
                    case "2":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (salaryAmt.compareTo(tempTotalAmount) == 1 || salaryAmt.compareTo(tempTotalAmount) == 0) {
                                publisherWalletFlowVO.setSalaryAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(salaryAmt);
                                publisherWalletFlowVO.setSalaryAmount(salaryAmt);
                            }
                        }

                        break;
                    case "3":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            requirementsInfoDO.setWeChat(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        }
                        break;
                    default:
                        break;
                }
            }
        }
        if (tempTotalAmount.compareTo(BigDecimal.ZERO) == 0) {
            //表示订单计算完成，需要支付的钱都算出来了
            System.out.println(requirementsInfoDO);
            System.out.println(publisherWalletFlowVO);
            BigDecimal weChat = requirementsInfoDO.getWeChat();

            BigDecimal levelWeChatAmount = requirementsInfoDO.getLevelWeChatAmount();
            BigDecimal add = weChat.add(levelWeChatAmount);
            orderNumberDTO.setWeChatPay(add);
            if (orderNumberDTO.getWeChatPay().compareTo(BigDecimal.ZERO) != 0) {
                orderNumberDTO.setPaymentOrderNumber(randomOrderCode());
                stringRedisTemplate.opsForValue().set(orderNumberDTO.getPaymentOrderNumber(), JsonUtil.parseObjToJson(orderNumberDTO));
            }
            return ResultBody.success(orderNumberDTO);
        } else {
            //云享金和佣金扣除完成，但是还不足支付订单金额，并且没有选择微信支付，所以支付不合法
            return ResultBody.success("下单失败");
        }


    }

    @Override
    public PageResult myPreempt(Integer userAccountId, MyPreemptQO param) {
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        param.setUserAccountId(userAccountId);
        int count = requirementsDao.myPreemptCount(param);
        List<RequirementsInfoDO> requirementsInfoDOS = requirementsDao.myPreempt(param);
        List<RequirementsInfoVO> collect = requirementsInfoDOS.stream().map(RequirementsInfoDO::buildRequirementsInfoVO).collect(Collectors.toList());

        return PageResult.buildPage(pageNo, param.getPageSize(), count, collect);
    }

    @Override
    public ResultBody droneFlyerCancel(Integer requirementsInfoId, Integer userAccountId, HttpServletRequest request) {

        RequirementsServiceDO requirementsServiceDO = requirementsDao.droneFlyerCancel(requirementsInfoId, userAccountId);
        Integer serviceFlowId = requirementsServiceDO.getServiceFlowId();
        if (serviceFlowId != 2) {
            return ResultBody.error(ResultEnum.YOU_CANNOT_CANCEL_THE_ORDER_AT_THIS_TIME.getResultMsg());
        }
        BigDecimal bigDecimal = new BigDecimal(0.9);
        BigDecimal preemptTotalAmount = requirementsServiceDO.getPreemptTotalAmount();
        BigDecimal percentagePenaltyOfOrder = preemptTotalAmount.multiply(bigDecimal).setScale(2, BigDecimal.ROUND_HALF_UP);
        WalletFlowVO walletFlowVO = new WalletFlowVO();
        FlyerWalletFlowVO flyerWalletFlowVO = new FlyerWalletFlowVO();
        IsNullConvertZeroUtil.checkIsNull(flyerWalletFlowVO);
        IsNullConvertZeroUtil.checkIsNull(walletFlowVO);
        PublisherWalletFlowVO publisherWalletFlowVO = new PublisherWalletFlowVO();
        IsNullConvertZeroUtil.checkIsNull(walletFlowVO);
        flyerWalletFlowVO.setModeOfPayment(600);
        flyerWalletFlowVO.setPercentagePenaltyOfOrder(percentagePenaltyOfOrder);
        flyerWalletFlowVO.setUserAccountId(userAccountId);
        flyerWalletFlowVO.setOperateUserAccountId(userAccountId);
        walletFlowVO.setFlyerWalletFlowVO(flyerWalletFlowVO);
        publisherWalletFlowVO.setUserAccountId(requirementsServiceDO.getUserAccountId());
        publisherWalletFlowVO.setModeOfPayment(600);
        walletFlowVO.setPublisherWalletFlowVO(publisherWalletFlowVO);
        //任务佣金
        requirementsServiceDO.setPercentagePenaltyOfOrder(percentagePenaltyOfOrder);
        //飞手单方面取消将20之二十退回到发布者佣金里面
        flyerCancel(walletFlowVO, request.getHeader("token"));
        requirementsDao.updateScene(requirementsInfoId, 7);
        requirementsDao.updateInfo(requirementsInfoId, 7);
        this.sendMsgFlyerInfoAuth(requirementsServiceDO);
        return ResultBody.success(ResultEnum.PAYMENT_SUCCESS.getResultMsg());
    }


    private void sendMsgFlyerInfoAuth(RequirementsServiceDO requirementsServiceDO) {


        //订单编号

        JSONObject value1 = new JSONObject();
        value1.put("value", requirementsServiceDO.getPublisherNumber());

        //订单金额
        JSONObject value2 = new JSONObject();
        value2.put("value", requirementsServiceDO.getOrderAmount());

        //下单时间
        JSONObject value3 = new JSONObject();
        value3.put("value", requirementsServiceDO.getCreateTime());

        //取消时间
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");// 设置日期格式
        String date = df.format(new Date());
        JSONObject value4 = new JSONObject();
        value4.put("value", date);


     /*   //不通过原因
        String reason = null;
        if (param.getAuditStatus() == 1) {
            reason = userAccountDO.getUserName() + match.getMessage();
        }
        if (param.getAuditStatus() == 2) {
            PilotReasonDO pilotReasonDO = certificationDao.selectPilotReason(param.getReasonId());
            reason = pilotReasonDO.getReason();
        }
        value4.put("value", reason);*/


        JSONObject value5 = new JSONObject();
        value5.put("value", "");

        JSONObject datad = new JSONObject();
        //订单编号
        datad.put("character_string2", value1);
        //订单金额
        datad.put("amount3", value2);
        //下单时间
        datad.put("date5", value3);
        //取消时间
        datad.put("time7", value4);
        //备注
        datad.put("thing4", value5);

        AppletMsgVOS appletMsgVO = new AppletMsgVOS();
        appletMsgVO.setTouser(requirementsServiceDO.getOpenid());
        appletMsgVO.setTemplate_id(WxMsgTemplete.INDEMNIFY_FOR_PUBLICATION);
        appletMsgVO.setPage("pages/welcome/index");
        appletMsgVO.setData(datad);
        appletMsgVO.setMiniprogram_state(userSystemConstant.getMiniProgramState());
        appletMsgVO.setLang("zh_CN");
        sendUserAppletMsg(appletMsgVO);
    }

    /**
     * 小程序-用户端-发送消息
     */
    public ResultBody sendUserAppletMsg(AppletMsgVOS aMsg) {
        System.out.println("###########开始发送-小程序-用户端消息##########");
        String accessToken = null;
        try {
            accessToken = getStableAccessToken();
            System.out.println("accesstoken:" + accessToken);
        } catch (Exception e) {
            System.out.println("accessToken获取失败:" + e.getMessage());
            return ResultBody.error(ResultEnum.WX_ACCESS_TOKEN_ERROR.getResultCode(),
                    ResultEnum.WX_ACCESS_TOKEN_ERROR.getResultMsg() + e.getMessage());
        }
        try {
            String url = "https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token=" + accessToken;
            aMsg.setData(WxApiUtilS.buildMsgJson(aMsg.getData()));
            System.out.println(aMsg);

            String param = JsonUtil.parseObjToJson(aMsg);
            System.out.println("参数：" + param);
            String result = HttpsOpenUtil.httpSendPost(url, param);
            JSONObject resJson = JSONObject.parseObject(result);
            if ("40001".equals(resJson.getString("errcode"))) {
                UserSystemConstant userSystemConstant = new UserSystemConstant();
                stringRedisTemplate.delete(createWxToken(userSystemConstant.getWxAppId()));
                System.out.println("accessToken二次获取失败:" + resJson);
                return ResultBody.error(ResultEnum.WX_ACCESS_TOKEN_ERROR.getResultCode(),
                        ResultEnum.WX_ACCESS_TOKEN_ERROR.getResultMsg() + resJson);
            }
            System.out.println(result);
        } catch (Exception e) {
            System.out.println("系统异常：" + e.getMessage());
        }
        System.out.println("###########结束发送-小程序-消息##########");
        return ResultBody.success();
    }


    public String getStableAccessToken() {
        //token有效期为7200s，需要保存起来，先从redis中获取accessToken，没有则请求获取
        String accessToken = stringRedisTemplate.opsForValue().get(WxConstant.IUAV_MINI_PROGRAM_STABLE_ACCESS_TOKEN);
        if (org.apache.commons.lang.StringUtils.isBlank(accessToken)) {
            Map<String, String> params = new HashMap<String, String>();
            params.put("grant_type", "client_credential");
            params.put("appid", userSystemConstant.getWxAppId());
            params.put("secret", userSystemConstant.getWxAppSecret());
            String stableAccessTokenUrl = "https://api.weixin.qq.com/cgi-bin/stable_token";
            String res = null;
            try {
                res = HttpsRequestUtil.httpsRequest(stableAccessTokenUrl, "POST", null, JSONObject.toJSONString(params));
            } catch (Exception e) {
                e.printStackTrace();
            }
            JSONObject tokenResult = JSONObject.parseObject(res);
            if (res.indexOf("access_token") == -1) {
                return null;
            }
            accessToken = tokenResult.getString("access_token");
            long expiresIn = tokenResult.getLong("expires_in");
            //保存进redis
            stringRedisTemplate.opsForValue().set(WxConstant.IUAV_MINI_PROGRAM_STABLE_ACCESS_TOKEN, accessToken, expiresIn, TimeUnit.SECONDS);
            return accessToken;
        }
        return accessToken;
    }


    @Override
    public ResultBody publisherCancel(Integer requirementsInfoId, Integer userAccountId, HttpServletRequest request) {
        RequirementsInfoDO requirementsInfoDO = requirementsDao.publisherCancel(requirementsInfoId, userAccountId);
        Integer serviceFlowId = requirementsInfoDO.getServiceFlowId();
        ApplyRefundVO applyRefundVO = new ApplyRefundVO();
        WalletFlowVO walletFlowVO = new WalletFlowVO();
        PublisherWalletFlowVO publisherWalletFlowVO = new PublisherWalletFlowVO();
        IsNullConvertZeroUtil.checkIsNull(publisherWalletFlowVO);
        if (serviceFlowId == 1) {
            //飞手无责取消 将全部退回 不包含加急或者置顶
            //支付
            if (requirementsInfoDO.getCashAmount().compareTo(BigDecimal.ZERO) != 0 ||
                    requirementsInfoDO.getSalaryAmount().compareTo(BigDecimal.ZERO) != 0) {
                publisherWalletFlowVO.setModeOfPayment(200);
                publisherWalletFlowVO.setUserAccountId(userAccountId);
                publisherWalletFlowVO.setOperateUserAccountId(userAccountId);
                walletFlowVO.setPublisherWalletFlowVO(publisherWalletFlowVO);
                flyerCancel(walletFlowVO, request.getHeader("token"));
            }
            if (requirementsInfoDO.getWechatPayOrderNumber() != null
                    && requirementsInfoDO.getWeChat().compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal weChat = requirementsInfoDO.getWeChat();
                BigDecimal multiply = weChat.multiply(new BigDecimal(100));
                Long longWeChat = multiply.longValue();
                applyRefundVO.setRefund(longWeChat);
                applyRefundVO.setOutTradeNo(requirementsInfoDO.getWechatPayOrderNumber());
                applyRefundVO.setReason("退发布者微信支付的任务佣金");
                applyRefund(applyRefundVO, request.getHeader("token"));
            }
            return ResultBody.success(ResultEnum.THE_AMOUNT_OF_THE_MISSION_WILL_BE_RETURNED.getResultMsg());
        }
        if (serviceFlowId != 2 && serviceFlowId != 1) {
            return ResultBody.error(ResultEnum.YOU_CANNOT_CANCEL_THE_ORDER_AT_THIS_TIME.getResultMsg());
        }
        //单方面取消订单并且飞手已经抢单
        if (serviceFlowId == 2) {

            BigDecimal orderAmount = requirementsInfoDO.getOrderAmount();
            BigDecimal bigDecimal = new BigDecimal(0.7);
            //剩余金额
            BigDecimal residueOrderAmount = orderAmount.multiply(bigDecimal).setScale(2, BigDecimal.ROUND_HALF_UP);
            //先退微信 再退任务佣金 最后退云享金
            BigDecimal weChat = requirementsInfoDO.getWeChat();

            //微信需要退款多少金额
            //微信金额大于扣除之后的金额

            BigDecimal refundCashAmount = new BigDecimal(0);
            BigDecimal refundSalaryAmount = new BigDecimal(0);
            BigDecimal refundWeChat = new BigDecimal(0);
            if (weChat.compareTo(residueOrderAmount) == 1) {
                refundWeChat = refundCashAmount;
                BigDecimal multiply = weChat.multiply(new BigDecimal(100));
                Long longWeChat = multiply.longValue();
                applyRefundVO.setRefund(longWeChat);
                applyRefundVO.setReason("扣除飞手百分之三十的费用");
                

                applyRefund(applyRefundVO, request.getHeader("token"));

            }


            return ResultBody.success(ResultEnum.REFUND_PERCENTAGE.getResultMsg());
        }
        return ResultBody.success();
    }

    /**
     * 全额退回
     *
     * @param requirementsInfoId
     * @param userAccountId
     * @return
     */
    @Override
    public ResultBody cancelAll(Integer requirementsInfoId, Integer userAccountId) {
        RequirementsServiceDO requirementsServiceDO = requirementsDao.droneFlyerCancel(requirementsInfoId, userAccountId);
        RequirementsInfoDO requirementsInfoDO = requirementsDao.publisherCancel(requirementsInfoId, userAccountId);
        requirementsDao.updateInfo(requirementsInfoId, 7);
        requirementsDao.updateScene(requirementsInfoId, 7);
        return ResultBody.success();
    }

    /**
     * 修改任务佣金
     *
     * @param amountVO
     * @param request
     * @return
     */
    @Override
    public ResultBody updatePublisherCancel(RequirementsAmountVO amountVO, HttpServletRequest request) {
        //requirementsDao.updatePublisherCancel();

        return null;
    }

    @Override
    public ResultBody<FlowDictionaryDTO> flowDictionary() {
        List<FlowDictionaryDO> flowDictionaryDOS = requirementsDao.flowDictionary();
        List<FlowDictionaryDTO> collect = flowDictionaryDOS.stream().map(FlowDictionaryDO::buildFlowDictionaryDTO).collect(Collectors.toList());
        return ResultBody.success(collect);
    }

    @Override
    public ResultBody confirmSettlement(Integer userAccountId) {
        return ResultBody.success();
    }


    @Override
    public ResultBody publishService(ServiceRequirementsVO serviceRequirementsVO, HttpServletRequest request) {

        //获取用户基本信息
        UserAccountSimpleDTO userAccountSimpleDTO = feignGetUserSimpleInfo(serviceRequirementsVO.getUserAccountId(), request);
        String openid = userAccountSimpleDTO.getOpenid();
        //需要冻结的金额
        WalletFlowVO walletFlowVO = new WalletFlowVO();
        // PublisherWalletFlowVO publisherWalletFlowVO = walletFlowVO.getPublisherWalletFlowVO();
        PublisherWalletFlowVO publisherWalletFlowVO = new PublisherWalletFlowVO();
        publisherWalletFlowVO.setUserAccountId(serviceRequirementsVO.getUserAccountId());
        publisherWalletFlowVO.setOperateUserAccountId(serviceRequirementsVO.getUserAccountId());
        ServiceRequirementsDO requirementsInfoDO = new ServiceRequirementsDO(serviceRequirementsVO);
        requirementsInfoDO.setPublisherNumber(randomOrderCode());
        IsNullConvertZeroUtil.checkIsNull(publisherWalletFlowVO);
        IsNullConvertZeroUtil.checkIsNull(requirementsInfoDO);

        //获取用户钱包
        ResultBody resultBody = getCurrentUserPayWalletInfo(request);
        PayWalletDTO payWalletDTO = (PayWalletDTO) resultBody.getResult();

        //需要支付的总金额
        BigDecimal orderAmount = requirementsInfoDO.getOrderAmount();
        //需要支付加急或者置顶金额
        BigDecimal rushAndTop = OrderLevelEnum.match(serviceRequirementsVO.getOrderLevelEnum().getKey()).getValue();
        String orderLevelEnum = OrderLevelEnum.match(serviceRequirementsVO.getOrderLevelEnum().getKey()).getKey();


        //云享金
        BigDecimal cashAmt = payWalletDTO.getCashAmt();
        //佣金
        BigDecimal salaryAmt = payWalletDTO.getSalaryAmt();

        String json = stringRedisTemplate.opsForValue().get(requirementsInfoDO.getWechatPayOrderNumber() + requirementsInfoDO.getUserAccountId());
        GetOrderNumberDTO orderNumberDTO = JSONObject.parseObject(json, GetOrderNumberDTO.class);

        String paymentType = requirementsInfoDO.getPaymentType();
        String[] split = paymentType.split(",");
        Set<String> collect = Arrays.asList(split).stream().collect(Collectors.toSet());
        TreeSet<String> objects = new TreeSet<>(collect);

        //用户剩余的佣金
        BigDecimal userSalaryAmt = new BigDecimal(0);
        //云享金余额还剩余多少
        BigDecimal userCashAmt = new BigDecimal(0);
        BigDecimal tempTotalAmount = new BigDecimal(0);
        //存在置顶或加急
        if (rushAndTop.compareTo(BigDecimal.ZERO) != 0) {
            tempTotalAmount = rushAndTop;
            for (String type : objects) {
                switch (type) {
                    case "1":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (cashAmt.compareTo(tempTotalAmount) == 1 || cashAmt.compareTo(tempTotalAmount) == 0) {
                                // walletFlowVO.setCashAmount(tempTotalAmount);
                                //加急云享金支付
                                if (orderLevelEnum.equals("RUSH_ORDER")) {
                                    publisherWalletFlowVO.setUrgentYxjAmount(tempTotalAmount);
                                    requirementsInfoDO.setLevelCashAmount(tempTotalAmount);
                                } else if (orderLevelEnum.equals("TOP_ORDER")) {
                                    publisherWalletFlowVO.setTopYxjAmount(cashAmt);
                                    requirementsInfoDO.setLevelCashAmount(tempTotalAmount);
                                }
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(cashAmt);
                                // walletFlowVO.setCashAmount(cashAmt);
                                if (orderLevelEnum.equals("RUSH_ORDER")) {
                                    publisherWalletFlowVO.setUrgentYxjAmount(cashAmt);
                                    requirementsInfoDO.setLevelCashAmount(cashAmt);
                                } else if (orderLevelEnum.equals("TOP_ORDER")) {
                                    System.out.println(cashAmt);

                                    publisherWalletFlowVO.setTopYxjAmount(cashAmt);
                                    requirementsInfoDO.setLevelCashAmount(cashAmt);
                                }
                            }
                        }
                        break;
                    case "2":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (salaryAmt.compareTo(tempTotalAmount) == 1 || salaryAmt.compareTo(tempTotalAmount) == 0) {
                                //  walletFlowVO.setSalaryAmount(tempTotalAmount);
                                publisherWalletFlowVO.setTopSalaryAmount(tempTotalAmount);
                                if (orderLevelEnum.equals("RUSH_ORDER")) {
                                    publisherWalletFlowVO.setUrgentSalaryAmount(tempTotalAmount);
                                    requirementsInfoDO.setLevelSalaryAmount(tempTotalAmount);
                                } else if (orderLevelEnum.equals("TOP_ORDER")) {
                                    publisherWalletFlowVO.setTopSalaryAmount(tempTotalAmount);
                                    requirementsInfoDO.setLevelSalaryAmount(tempTotalAmount);
                                }

                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(salaryAmt);
                                // walletFlowVO.setSalaryAmount(salaryAmt);
                                publisherWalletFlowVO.setTopSalaryAmount(salaryAmt);
                                requirementsInfoDO.setLevelSalaryAmount(salaryAmt);
                                if (orderLevelEnum.equals("RUSH_ORDER")) {
                                    publisherWalletFlowVO.setUrgentSalaryAmount(salaryAmt);
                                } else if (orderLevelEnum.equals("TOP_ORDER")) {
                                    publisherWalletFlowVO.setTopSalaryAmount(salaryAmt);
                                    requirementsInfoDO.setLevelSalaryAmount(salaryAmt);
                                }
                            }
                        }

                        break;
                    case "3":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            //需要支付微信
                            requirementsInfoDO.setLevelWeChatAmount(tempTotalAmount);
                            // walletFlowVO.setWeChat(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        }
                        break;
                    default:
                        break;
                }
            }

            System.out.println(requirementsInfoDO);
            System.out.println(publisherWalletFlowVO);

            if (orderLevelEnum.equals("RUSH_ORDER")) {
                //加急的云享金
                BigDecimal urgentYxjAmount = publisherWalletFlowVO.getUrgentYxjAmount();
                userCashAmt = cashAmt.subtract(urgentYxjAmount);
                BigDecimal urgentSalaryAmount = publisherWalletFlowVO.getUrgentSalaryAmount();
                userSalaryAmt = salaryAmt.subtract(urgentSalaryAmount);

            } else if (orderLevelEnum.equals("TOP_ORDER")) {
                //置顶的云享金
                BigDecimal topYxjAmount = publisherWalletFlowVO.getTopYxjAmount();
                userCashAmt = cashAmt.subtract(topYxjAmount);
                BigDecimal topSalaryAmount = publisherWalletFlowVO.getTopSalaryAmount();
                userSalaryAmt = salaryAmt.subtract(topSalaryAmount);
            }


            tempTotalAmount = orderAmount;
            //剩下的用于支付任务佣金
            for (String type : objects) {
                switch (type) {
                    case "1":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (userCashAmt.compareTo(tempTotalAmount) == 1 || userCashAmt.compareTo(tempTotalAmount) == 0) {
                                // walletFlowVO.setCashAmount(tempTotalAmount);
                                publisherWalletFlowVO.setCashAmount(tempTotalAmount);
                                requirementsInfoDO.setCashAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(userCashAmt);
                                publisherWalletFlowVO.setCashAmount(userCashAmt);
                                requirementsInfoDO.setCashAmount(userCashAmt);
                            }
                        }
                        break;
                    case "2":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (userSalaryAmt.compareTo(tempTotalAmount) == 1 || userSalaryAmt.compareTo(tempTotalAmount) == 0) {
                                publisherWalletFlowVO.setSalaryAmount(tempTotalAmount);
                                requirementsInfoDO.setSalaryAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(userSalaryAmt);
                                publisherWalletFlowVO.setSalaryAmount(userSalaryAmt);
                                requirementsInfoDO.setSalaryAmount(userSalaryAmt);
                            }
                        }

                        break;
                    case "3":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            // publisherWalletFlowVO.setWeChat(tempTotalAmount);
                            requirementsInfoDO.setWeChat(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        }
                        break;
                    default:
                        break;
                }
            }


        }

        System.out.println(requirementsInfoDO);
        System.out.println(publisherWalletFlowVO);


        //不存在加急或者置顶
        if (rushAndTop.compareTo(BigDecimal.ZERO) == 0) {
            tempTotalAmount = orderAmount;
            for (String type : objects) {
                switch (type) {
                    case "1":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (cashAmt.compareTo(tempTotalAmount) == 1 || cashAmt.compareTo(tempTotalAmount) == 0) {
                                publisherWalletFlowVO.setCashAmount(tempTotalAmount);
                                // walletFlowVO.setCashAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(cashAmt);
                                publisherWalletFlowVO.setCashAmount(cashAmt);
                                //  walletFlowVO.setCashAmount(cashAmt);
                            }
                        }
                        break;
                    case "2":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (salaryAmt.compareTo(tempTotalAmount) == 1 || salaryAmt.compareTo(tempTotalAmount) == 0) {
                                publisherWalletFlowVO.setSalaryAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(salaryAmt);
                                publisherWalletFlowVO.setSalaryAmount(salaryAmt);
                            }
                        }

                        break;
                    case "3":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            requirementsInfoDO.setWeChat(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        }
                        break;
                    default:
                        break;
                }
            }
        }

        System.out.println(requirementsInfoDO);
        System.out.println(publisherWalletFlowVO);
        if (tempTotalAmount.compareTo(BigDecimal.ZERO) == 0) {
            System.out.println(requirementsInfoDO);
            System.out.println(publisherWalletFlowVO);
            System.out.println(requirementsInfoDO);
            if (orderNumberDTO != null) {
                requirementsInfoDO.setWechatPayOrderNumber(orderNumberDTO.getPaymentOrderNumber());
            } else if (orderNumberDTO == null) {
                requirementsInfoDO.setWechatPayOrderNumber(null);
            }
            if (orderNumberDTO != null) {
                BigDecimal weChatPay = orderNumberDTO.getWeChatPay();
                if (requirementsInfoDO.getWechatPayOrderNumber().equals(orderNumberDTO.getPaymentOrderNumber())) {
                    BigDecimal weChat = requirementsInfoDO.getWeChat();
                    BigDecimal levelWeChatAmount = requirementsInfoDO.getLevelWeChatAmount();
                    BigDecimal add = weChat.add(levelWeChatAmount);
                    if (weChatPay.compareTo(add) != 0) {
                        return ResultBody.error("订单号错误下单失败");
                    }
                }
            }
            requirementsInfoDO.setOpenid(openid);
            requirementsDao.addPublishService(requirementsInfoDO);
            RequirementsAmountDO requirementsAmountDO = new RequirementsAmountDO(requirementsInfoDO);
            requirementsDao.addAmount(requirementsAmountDO);
            if (requirementsAmountDO.getCashAmount().compareTo(BigDecimal.ZERO) != 0
                    || requirementsAmountDO.getSalaryAmount().compareTo(BigDecimal.ZERO) != 0
                    || requirementsAmountDO.getLevelCashAmount().compareTo(BigDecimal.ZERO) != 0
                    || requirementsAmountDO.getLevelSalaryAmount().compareTo(BigDecimal.ZERO) != 0) {
                feignWalletFlow(publisherWalletFlowVO, request.getHeader("token"));
            }
            return ResultBody.success();
        } else {
            //云享金和佣金扣除完成，但是还不足支付订单金额，并且没有选择微信支付，所以支付不合法
            return ResultBody.success("下单失败");
        }
    }


    /**
     * 获取用户钱包信息
     *
     * @param
     * @param request
     * @return
     */
    public ResultBody getCurrentUserPayWalletInfo(HttpServletRequest request) {
        String token = request.getHeader("token");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<MultiValueMap<String, Object>> formEntity = new HttpEntity<MultiValueMap<String, Object>>(headers);
        ResponseEntity<String> exchange = null;
        try {
            exchange = restTemplate.exchange(userApp + "/userapp/pay/getCurrentUserPayWalletInfo", HttpMethod.GET, formEntity, String.class);
        } catch (RestClientException e) {
            return ResultBody.error(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED);
        }
        Object body = exchange.getBody();
        JSONObject jsonObject = JSONObject.parseObject((String) body);
        JSONObject result1 = (JSONObject) jsonObject.get("result");
        PayWalletDTO payWalletDTO = JSON.parseObject(result1.toJSONString(), PayWalletDTO.class);
        return ResultBody.success(payWalletDTO);
    }


    @Override
    public PageResult myPublish(Integer userAccountId, MyPublishQO param) {
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        param.setUserAccountId(userAccountId);
        int count = requirementsDao.myPublishcount(param);
        List<RequirementsInfoDO> requirementsInfoDOS = requirementsDao.myPublish(param);
        List<RequirementsInfoVO> collect = requirementsInfoDOS.stream().map(RequirementsInfoDO::buildRequirementsInfoVO).collect(Collectors.toList());
        return PageResult.buildPage(pageNo, param.getPageSize(), count, collect);

    }


    @Override
    public ResultBody grabTheOrder(GrabTheOrderVO grabTheOrderVO, HttpServletRequest request) {

        UserAccountSimpleDTO userAccountSimpleDTO = feignGetUserSimpleInfo(grabTheOrderVO.getUserAccountId(), request);
        String openid = userAccountSimpleDTO.getOpenid();

        ServiceRequirementsDO requirementsInfoDO = requirementsDao.grabTheOrder(grabTheOrderVO.getRequirementsInfoId());
        if (grabTheOrderVO.getRequirementsInfoId().equals(requirementsInfoDO.getId()) && grabTheOrderVO.getUserAccountId().equals(requirementsInfoDO.getUserAccountId())) {
            return ResultBody.error("自己不能抢自己发布的需求");
        }
        //飞手
        PilotCertificationInteriorDTO pilot = feignInteriorDetailPilot(grabTheOrderVO.getUserAccountId(), request);
        if (pilot == null) {
            return ResultBody.error("只能飞手或者飞手团队抢单");
        }

        Integer repertory = requirementsInfoDO.getRepertory();
        if (repertory <= 0) {
            return ResultBody.error("需求已被其他人抢走");
        }

        //  requirementsInfoDO.setPublisherNumber(randomOrderCode());
        ResultBody resultBody = getCurrentUserPayWalletInfo(request);
        PayWalletDTO payWalletDTO = (PayWalletDTO) resultBody.getResult();
        RequirementsServiceDO requirementsServiceDO = new RequirementsServiceDO(pilot, requirementsInfoDO);
        IsNullConvertZeroUtil.checkIsNull(requirementsServiceDO);

        //用户云享金+用户佣金>总金额
        //剩余后台云享金
        BigDecimal cashAmt = payWalletDTO.getCashAmt();
        //剩余佣金
        BigDecimal salaryAmt = payWalletDTO.getSalaryAmt();
        //用户云享金加上佣金的总金额
        BigDecimal cashAndSalary = cashAmt.add(salaryAmt);
        //需要支付的总金额(任务佣金)
        BigDecimal totalAmount = requirementsInfoDO.getOrderAmount();
        BigDecimal bigDecimal = new BigDecimal(0.3);
        totalAmount = totalAmount.multiply(bigDecimal).setScale(2, BigDecimal.ROUND_HALF_UP);
        String json = stringRedisTemplate.opsForValue().get(grabTheOrderVO.getWechatPayOrderNumber() + grabTheOrderVO.getUserAccountId());
        GetOrderNumberDTO orderNumberDTO = JSONObject.parseObject(json, GetOrderNumberDTO.class);
        IsNullConvertZeroUtil.checkIsNull(orderNumberDTO);
        //需要冻结的金额
        FlyerWalletFlowVO flyerWalletFlowVO = new FlyerWalletFlowVO();
        IsNullConvertZeroUtil.checkIsNull(flyerWalletFlowVO);
        //PublisherWalletFlowVO publisherWalletFlowVO = walletFlowVO.getPublisherWalletFlowVO();
        BigDecimal tempTotalAmount = totalAmount;
        String paymentType = grabTheOrderVO.getPaymentType();
        String[] split = paymentType.split(",");
        Set<String> collect = Arrays.asList(split).stream().collect(Collectors.toSet());
        TreeSet<String> objects = new TreeSet<>(collect);
        for (String type : objects) {
            switch (type) {
                case "1":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        if (cashAmt.compareTo(tempTotalAmount) == 1 || cashAmt.compareTo(tempTotalAmount) == 0) {
                            flyerWalletFlowVO.setCashAmount(tempTotalAmount);
                            requirementsServiceDO.setCashAmount(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        } else {
                            tempTotalAmount = tempTotalAmount.subtract(cashAmt);
                            flyerWalletFlowVO.setCashAmount(cashAmt);
                            requirementsServiceDO.setCashAmount(cashAmt);
                        }
                    }
                    break;
                case "2":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        if (salaryAmt.compareTo(tempTotalAmount) == 1 || salaryAmt.compareTo(tempTotalAmount) == 0) {
                            flyerWalletFlowVO.setSalaryAmount(tempTotalAmount);
                            requirementsServiceDO.setSalaryAmount(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        } else {
                            tempTotalAmount = tempTotalAmount.subtract(salaryAmt);
                            flyerWalletFlowVO.setSalaryAmount(salaryAmt);
                            requirementsServiceDO.setSalaryAmount(salaryAmt);
                        }
                    }
                    break;
                case "3":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        //  publisherWalletFlowVO.setWeChat(tempTotalAmount);
                        requirementsServiceDO.setWeChat(tempTotalAmount);
                        tempTotalAmount = BigDecimal.ZERO;
                    }
                    break;
                default:
                    break;
            }
        }
        if (tempTotalAmount.compareTo(BigDecimal.ZERO) == 0) {
            //表示订单计算完成，需要支付的钱都算出来了
            System.out.println(flyerWalletFlowVO);
            System.out.println(requirementsServiceDO);


            flyerWalletFlowVO.setUserAccountId(grabTheOrderVO.getUserAccountId());
            flyerWalletFlowVO.setOperateUserAccountId(grabTheOrderVO.getUserAccountId());
            // requirementsServiceDO.setCashAmount(walletFlowVO.getCashAmount());
            // requirementsServiceDO.setSalaryAmount(walletFlowVO.getSalaryAmount());
            requirementsServiceDO.setWeChat(orderNumberDTO.getWeChatPay());
            requirementsServiceDO.setWechatPayOrderNumber(orderNumberDTO.getPaymentOrderNumber());
            // BigDecimal cashAndSalaryAmount = walletFlowVO.getCashAmount().add(walletFlowVO.getSalaryAmount());
            // BigDecimal preemptTotalAmount = cashAndSalaryAmount.add(orderNumberDTO.getWeChatPay());
            //  requirementsServiceDO.setPreemptTotalAmount(preemptTotalAmount);
            BigDecimal cashAmount = requirementsServiceDO.getCashAmount();
            BigDecimal salaryAmount = requirementsServiceDO.getSalaryAmount();
            BigDecimal weChat = requirementsServiceDO.getWeChat();
            BigDecimal add = cashAmount.add(salaryAmount);
            BigDecimal add1 = add.add(weChat);
            requirementsServiceDO.setPreemptTotalAmount(add1);
            requirementsDao.insertService(requirementsServiceDO);
            requirementsInfoDO.setRepertory(repertory - 1);
            requirementsDao.updateGrabTheOrder(grabTheOrderVO.getRequirementsInfoId(), requirementsInfoDO.getRepertory());
            if (requirementsServiceDO.getCashAmount().compareTo(BigDecimal.ZERO) != 0
                    || requirementsServiceDO.getSalaryAmount().compareTo(BigDecimal.ZERO) != 0) {
                walletFlow(flyerWalletFlowVO, request.getHeader("token"));
            }

            return ResultBody.success();
        } else {
            //云享金和佣金扣除完成，但是还不足支付订单金额，并且没有选择微信支付，所以支付不合法
            return ResultBody.success("抢单失败");
        }
    }


    @Override
    public ResultBody arriveAtTheScene(ServiceArriveSceneVO serviceArriveSceneVO) {
        ServiceArriveSceneDO serviceArriveSceneDO = new ServiceArriveSceneDO(serviceArriveSceneVO);
        RequirementsInfoDO requirementsInfoDO = requirementsDao.detailPublish(serviceArriveSceneDO.getRequirementsInfoId());
        GlobalCoordinates source = new GlobalCoordinates(Double.parseDouble(String.valueOf(requirementsInfoDO.getLatitude())), Double.parseDouble(String.valueOf(requirementsInfoDO.getLongitude())));
        GlobalCoordinates target = new GlobalCoordinates(Double.parseDouble(String.valueOf(serviceArriveSceneDO.getLatitude())), Double.parseDouble(String.valueOf(serviceArriveSceneDO.getLongitude())));
        double geoCurve = getDistanceMeter(source, target, Ellipsoid.Sphere);
        //100米
        if (geoCurve > 100) {
            return ResultBody.error(ResultEnum.FALL_OUTSIDE_OF);
        } else {
            requirementsDao.arriveAtTheScene(serviceArriveSceneDO);
            requirementsDao.updateScene(serviceArriveSceneDO.getRequirementsInfoId(), 3);
            requirementsDao.updateInfo(serviceArriveSceneDO.getRequirementsInfoId(), 3);
        }
        return ResultBody.success();
    }

    /* 经纬度计算工具类*/
    public static double getDistanceMeter(GlobalCoordinates gpsFrom, GlobalCoordinates gpsTo, Ellipsoid ellipsoid) {
        //创建GeodeticCalculator，调用计算方法，传入坐标系、经纬度用于计算距离
        GeodeticCurve geoCurve = new GeodeticCalculator().calculateGeodeticCurve(ellipsoid, gpsFrom, gpsTo);
        return geoCurve.getEllipsoidalDistance();
    }

    @Override
    public ResultBody<ServiceArriveSceneDTO> arriveAtTheSceneDetails(Integer requirementsInfoId, Integer userAccountId) {
        ServiceArriveSceneDO serviceArriveSceneDO = requirementsDao.arriveAtTheSceneDetails(requirementsInfoId, userAccountId);
        ServiceArriveSceneDTO serviceArriveSceneDTO = serviceArriveSceneDO.buildServiceArriveSceneDTO();
        return ResultBody.success(serviceArriveSceneDTO);
    }


    @Override
    public ResultBody fulfilATask(ServiceFulfilATaskVO fulfilATaskVO) {
        ServiceFulfilATaskDO serviceFulfilATaskDO = new ServiceFulfilATaskDO(fulfilATaskVO);
        requirementsDao.fulfilATask(serviceFulfilATaskDO);
        requirementsDao.updateInfo(fulfilATaskVO.getRequirementsInfoId(), 4);
        requirementsDao.updateScene(fulfilATaskVO.getRequirementsInfoId(), 4);
        return ResultBody.success();
    }

    @Override
    public ResultBody<ServiceFulfilATaskDTO> fulfilATaskDetails(Integer requirementsInfoId, Integer userAccountId) {
        ServiceFulfilATaskDO serviceFulfilATaskDO = requirementsDao.fulfilATaskDetails(requirementsInfoId, userAccountId);
        ServiceFulfilATaskDTO serviceFulfilATaskDTO = serviceFulfilATaskDO.buildServiceFulfilATaskDTO();
        return ResultBody.success(serviceFulfilATaskDTO);
    }


    @Override
    public ResultBody settleAccounts(ServiceSettleAccountsVO settleAccountsVO) {
        ServiceSettleAccountsDO settleAccountsDO = new ServiceSettleAccountsDO(settleAccountsVO);
        requirementsDao.settleAccounts(settleAccountsDO);
        requirementsDao.updateScene(settleAccountsVO.getRequirementsInfoId(), 5);
        requirementsDao.updateInfo(settleAccountsVO.getRequirementsInfoId(), 5);

        return ResultBody.success();
    }

    @Override
    public ResultBody<ServiceSettleAccountsDTO> settleAccountsDetails(Integer requirementsInfoId, Integer userAccountId) {
        ServiceSettleAccountsDO settleAccountsDO = requirementsDao.settleAccountsDetails(requirementsInfoId, userAccountId);
        ServiceSettleAccountsDTO settleAccountsDTO = settleAccountsDO.buildServiceSettleAccountsDTO();
        return ResultBody.success(settleAccountsDTO);
    }

    @Override
    public ResultBody evaluate(ServiceEvaluateVO evaluateVO) {
        ServiceEvaluateDO serviceEvaluateDO = new ServiceEvaluateDO(evaluateVO);
        requirementsDao.evaluate(serviceEvaluateDO);
        requirementsDao.updateInfo(evaluateVO.getRequirementsInfoId(), 6);
        requirementsDao.updateScene(evaluateVO.getRequirementsInfoId(), 6);
        return ResultBody.success();
    }

    @Override
    public ResultBody<ServiceEvaluateDTO> evaluateDetails(Integer requirementsInfoId, Integer userAccountId) {
        ServiceEvaluateDO serviceEvaluateDO = requirementsDao.evaluateDetails(requirementsInfoId, userAccountId);
        ServiceEvaluateDTO serviceEvaluateDTO = serviceEvaluateDO.buildServiceEvaluateDTO();
        return ResultBody.success(serviceEvaluateDTO);
    }


    public UserAccountSimpleDTO feignGetUserSimpleInfo(Integer userAccountId, HttpServletRequest request) {
        String token = request.getHeader("token");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(userAccountId), headers);
        ResponseEntity<UserAccountSimpleDTO> exchange1 = restTemplate.exchange(userApp + "/userapp/user-account/feignGetUserSimpleInfo?userAccountId=" + userAccountId, HttpMethod.GET, entity, UserAccountSimpleDTO.class);
        UserAccountSimpleDTO body = exchange1.getBody();
        return body;
    }


    public PilotCertificationInteriorDTO feignInteriorDetailPilot(Integer userAccountId, HttpServletRequest request) {
        String token = request.getHeader("token");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(userAccountId), headers);
        ResponseEntity<PilotCertificationInteriorDTO> exchange1 = restTemplate.exchange(userApp + "/userapp/pilot/interiorDetailPilot?userAccountId=" + userAccountId, HttpMethod.GET, entity, PilotCertificationInteriorDTO.class);
        PilotCertificationInteriorDTO body = exchange1.getBody();
        return body;
    }


    /**
     * 退款
     */
    public ResultBody applyRefund(ApplyRefundVO applyRefundVO, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(applyRefundVO), headers);
        ResponseEntity<Object> exchange = null;
        try {
            exchange = restTemplate.exchange(paymentApp + "/payment/wechat/applyRefund", HttpMethod.POST, entity, Object.class);
        } catch (RestClientException e) {
            return ResultBody.error(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED);
        }
        return ResultBody.success();
    }


    /**
     * 公共调用
     *
     * @param walletFlowVO
     * @param token
     * @return
     */
    public ResultBody flyerCancel(WalletFlowVO walletFlowVO, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(walletFlowVO), headers);
        ResponseEntity<Object> exchange = null;
        try {
            exchange = restTemplate.exchange(userApp + "/userapp/pay/feignWalletFlow", HttpMethod.POST, entity, Object.class);
        } catch (RestClientException e) {
            return ResultBody.error(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED);
        }
        return ResultBody.success();
    }

    public ResultBody walletFlow(FlyerWalletFlowVO flyerWalletFlowVO, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        WalletFlowVO walletFlowVO = new WalletFlowVO();
        flyerWalletFlowVO.setModeOfPayment(400);
        flyerWalletFlowVO.setCashAmount(flyerWalletFlowVO.getCashAmount().negate());
        flyerWalletFlowVO.setSalaryCashPledge(flyerWalletFlowVO.getSalaryAmount().negate());
        walletFlowVO.setFlyerWalletFlowVO(flyerWalletFlowVO);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(walletFlowVO), headers);
        ResponseEntity<Object> exchange = null;
        try {
            exchange = restTemplate.exchange(userApp + "/userapp/pay/feignWalletFlow", HttpMethod.POST, entity, Object.class);
        } catch (RestClientException e) {
            return ResultBody.error(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED);
        }
        return ResultBody.success();
    }

    public ResultBody feignWalletFlow(PublisherWalletFlowVO publisherWalletFlowVO, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        WalletFlowVO walletFlowVO = new WalletFlowVO();
        publisherWalletFlowVO.setModeOfPayment(100);
        publisherWalletFlowVO.setCashAmount(publisherWalletFlowVO.getCashAmount().negate());
        publisherWalletFlowVO.setSalaryAmount(publisherWalletFlowVO.getSalaryAmount().negate());
        publisherWalletFlowVO.setUrgentYxjAmount(publisherWalletFlowVO.getUrgentYxjAmount().negate());
        publisherWalletFlowVO.setUrgentSalaryAmount(publisherWalletFlowVO.getUrgentSalaryAmount().negate());
        publisherWalletFlowVO.setTopYxjAmount(publisherWalletFlowVO.getTopYxjAmount().negate());
        publisherWalletFlowVO.setTopSalaryAmount(publisherWalletFlowVO.getTopSalaryAmount().negate());
        walletFlowVO.setPublisherWalletFlowVO(publisherWalletFlowVO);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(walletFlowVO), headers);
        ResponseEntity<Object> exchange = null;
        try {
            exchange = restTemplate.exchange(userApp + "/userapp/pay/feignWalletFlow", HttpMethod.POST, entity, Object.class);
        } catch (RestClientException e) {
            return ResultBody.error(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED);
        }
        return ResultBody.success();
    }

    public ResultBody releaseOrder(RequirementsInfoVO requirementsInfoVO, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(requirementsInfoVO), headers);
        ResponseEntity<Object> exchange = null;
        try {
            exchange = restTemplate.exchange(omsApp + "releaseOrder/publish", HttpMethod.POST, entity, Object.class);
        } catch (RestClientException e) {
            return ResultBody.error(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED);
        }
        return ResultBody.success();
    }


    public List<IndustryTypeDTO> listIndustry() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<String> entity = new HttpEntity<>(null, headers);
        ResponseEntity<List> exchange = restTemplate.exchange(pmsApp + "/pms/industry/listIndustry", HttpMethod.GET, entity, List.class);
        List<IndustryTypeDTO> body = (List<IndustryTypeDTO>) exchange.getBody();
        String s = JSON.toJSONString(body);
        List<IndustryTypeDTO> industryTypeDTOS = JSONObject.parseArray(s, IndustryTypeDTO.class);
        ArrayList<IndustryTypeDTO> list = new ArrayList<>();
        for (IndustryTypeDTO industryTypeDTO : industryTypeDTOS) {
            list.add(industryTypeDTO);
        }
        return list;
    }


    public IndustryTypeDTO getIndustryTypeById(Integer serviceId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<String> entity = new HttpEntity<>(null, headers);
        ResponseEntity<String> exchange = restTemplate.exchange(pmsApp + "/pms/industry/getIndustryTypeById?id=+" + serviceId, HttpMethod.GET, entity, String.class);
        String body = exchange.getBody();
        IndustryTypeDTO industryTypeDTO = JSONObject.parseObject(body, IndustryTypeDTO.class);
        return industryTypeDTO;
    }

    public String randomOrderCode() {
        SimpleDateFormat dmDate = new SimpleDateFormat("yyyyMMddHHmmss");
        String ranData = getRandom(6);
        Date date = new Date();
        String dateRan = dmDate.format(date);
        String xsCode = "R" + dateRan + ranData;
        if (xsCode.length() < 24) {
            xsCode = xsCode + 0;
        }
        return xsCode;
    }

    public String getRandom(int len) {
        Random r = new Random();
        StringBuilder rs = new StringBuilder();
        for (int i = 0; i < len; i++) {
            rs.append(r.nextInt(10));
        }
        return rs.toString();
    }


}
