package com.mmc.csf.infomation.dto;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/8/18 21:22
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ServiceSettleAccountsDTO {

    private Integer id;

    @ApiModelProperty(value = "订单金额", example = "100")
    private BigDecimal orderAmount;

    @ApiModelProperty(value = "备注", example = "项目延期")
    private String remark;

    @ApiModelProperty(value = "需求id", example = "83")
    private Integer requirementsInfoId;

    @ApiModelProperty(value = "结算的用户id", example = "1", hidden = true)
    private Integer userAccountId;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

}
