package com.mmc.csf.release.service;

import javax.servlet.http.HttpServletRequest;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.forum.vo.CommentVO;
import com.mmc.csf.release.forum.vo.DynamicVO;
import com.mmc.csf.release.gambit.qo.ForumGambitQO;
import com.mmc.csf.release.gambit.qo.PostingLeaderboardQO;
import java.util.List;
/**
 * @Author LW 测试合并
 * @date 2023/5/15 10:29 概要：动态信息service层
 */
public interface DynamicService {
    /**
     * 插入动态
     *
     * @param dynamicVO 动态
     * @return {@link ResultBody}
     */
    ResultBody insertDynamic(DynamicVO dynamicVO, Integer userAccountId, HttpServletRequest request);

    /**
     * 点赞动态
     *
     * @param userId    用户id
     * @param dynamicId 动态id
     * @return {@link ResultBody}
     */
    ResultBody likeDynamic(Integer userId, Integer dynamicId);

    /**
     * 评论动态
     *
     * @param commentVO 评论信息
     * @return {@link ResultBody}
     */
    ResultBody commentDynamic(CommentVO commentVO, Integer userAccountId, HttpServletRequest request);

    /**
     * 删除评论
     *
     * @param id id
     * @return {@link ResultBody}
     */
    ResultBody deleteComment(Integer id);

    /**
     * 动态细节
     *
     * @param dynamicId 动态id
     * @param userId    用户id
     * @return {@link ResultBody}
     */
    ResultBody dynamicDetails(Integer dynamicId, Integer userId, HttpServletRequest request);

    PageResult dynamicList(
            Integer pageNo, Integer pageSize, Integer userAccountId, HttpServletRequest request, Integer gambitId, Integer id, Integer userId, String description, List<String> gambitName);

    ResultBody recentNewsList(Integer userAccountId);

    PageResult appGambitList(ForumGambitQO forumGambitQO);

    ResultBody reviewLikes(Integer id, Integer userAccountId, Boolean status);

    PageResult postingLeaderboard(PostingLeaderboardQO postingLeaderboardQO);
}
