package com.mmc.csf.release.controller;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.forum.dto.DynamicInfoDTO;
import com.mmc.csf.release.forum.qo.DynamicQO;
import com.mmc.csf.release.forum.vo.UserBaseInfoVO;
import com.mmc.csf.release.service.BackstageForumService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

/**
 * @Author LW
 * @date 2023/6/19 10:44 概要：
 */
@Api(tags = {"后台-论坛管理-模块"})
@RestController
@RequestMapping("/backstage/forum")
public class BackstageForumController {

    @Autowired
    BackstageForumService backstageForumService;

    @ApiOperation(value = "后台-动态列表")
    @PostMapping("/listDynamic")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = DynamicInfoDTO.class)})
    public ResultBody<DynamicInfoDTO> listDynamic(
            @RequestBody DynamicQO dynamic, HttpServletRequest request) {
        return ResultBody.success(backstageForumService.listDynamic(dynamic, request));
    }

    @ApiOperation(value = "动态删除")
    @GetMapping("/deleteDynamic")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody deleteDynamic(@RequestParam Integer dynamicId) {
        return backstageForumService.deleteDynamic(dynamicId);
    }

    @ApiOperation(value = "动态隐藏")
    @GetMapping("/hiddenDynamic")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody hiddenDynamic(@RequestParam Integer dynamicId) {
        return backstageForumService.hiddenDynamic(dynamicId);
    }

    @ApiOperation(value = "点赞用户信息")
    @GetMapping("/likeUserInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserBaseInfoVO.class)})
    public ResultBody likeUserInfo(@RequestParam Integer dynamicId, HttpServletRequest request) {
        return backstageForumService.likeUserInfo(dynamicId, request);
    }

    @ApiOperation(value = "审核动态")
    @GetMapping("/checkDynamic")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody checkDynamic(@RequestParam Integer dynamicId, @RequestParam Boolean status) {
        return backstageForumService.checkDynamic(dynamicId, status);
    }
}
