package com.mmc.csf.release.service.impl;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.dto.UserAccountSimpleDTO;
import com.mmc.csf.release.auth.qo.UserAccountQO;
import com.mmc.csf.release.constant.TokenConstant;
import com.mmc.csf.release.dao.BackstageForumDao;
import com.mmc.csf.release.dao.DynamicDAO;
import com.mmc.csf.release.dao.LikeDAO;
import com.mmc.csf.release.entity.forum.ForumDynamicDO;
import com.mmc.csf.release.entity.forum.ForumLikeDO;
import com.mmc.csf.release.entity.forum.ForumResourceDO;
import com.mmc.csf.release.feign.UserAppApi;
import com.mmc.csf.release.forum.dto.DynamicInfoDTO;
import com.mmc.csf.release.forum.qo.DynamicQO;
import com.mmc.csf.release.forum.vo.UserBaseInfoVO;
import com.mmc.csf.release.service.BackstageForumService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author LW
 *
 * @date 2023/6/19 10:47 概要：
 */
@Service
public class BackstageForumServiceImpl implements BackstageForumService {
  @Autowired BackstageForumDao backstageForumDao;
  @Autowired DynamicDAO dynamicDAO;
  @Autowired UserAppApi userAppApi;
  @Autowired LikeDAO likeDAO;

  @Override
  public PageResult listDynamic(DynamicQO dynamic, HttpServletRequest request) {
    List<Integer> userIds = null;
    if (dynamic.getKeyword() != null) {
      UserAccountQO userAccountQO = new UserAccountQO();
      userAccountQO.setKeyword(dynamic.getKeyword());
      // 获取筛选的用户id
      List<UserAccountSimpleDTO> userAccountSimpleDTOS =
          userAppApi.feignListAppUserAccount(userAccountQO, request.getHeader(TokenConstant.TOKEN));
      if (CollectionUtils.isNotEmpty(userAccountSimpleDTOS)) {
        // 获取用户id
        userIds =
            userAccountSimpleDTOS.stream()
                .map(UserAccountSimpleDTO::getId)
                .collect(Collectors.toList());
      }
      if (userIds == null) {
        return PageResult.buildPage(dynamic.getPageNo(), dynamic.getPageSize(), 0);
      }
    }
    int count = backstageForumDao.countDynamic(userIds);
    if (count == 0) {
      return PageResult.buildPage(dynamic.getPageNo(), dynamic.getPageSize(), count);
    }
    int itemIndex = (dynamic.getPageNo() - 1) * dynamic.getPageSize();
    // 获取动态信息
    List<ForumDynamicDO> dynamicList =
        backstageForumDao.listDynamicInfo(userIds, itemIndex, dynamic.getPageSize());
    // 动态id集合
    List<Integer> ids =
        dynamicList.stream().map(ForumDynamicDO::getId).collect(Collectors.toList());
    // 根据id集合查询图片
    List<ForumResourceDO> forumImageList = dynamicDAO.listDynamicPicture(ids);
    Map<Integer, List<ForumResourceDO>> ImageMap =
        forumImageList.stream().collect(Collectors.groupingBy(ForumResourceDO::getDynamicId));
    // 获取用户信息
    Set<Integer> listUserIds =
        dynamicList.stream().map(ForumDynamicDO::getUserAccountId).collect(Collectors.toSet());
    List<Integer> userIdList = new ArrayList<>(listUserIds);
    UserAccountQO accountQO = new UserAccountQO();
    accountQO.setUserIds(userIdList);
    List<UserAccountSimpleDTO> userAccountSimpleList =
        userAppApi.feignListAppUserAccount(accountQO, request.getHeader(TokenConstant.TOKEN));
    Map<Integer, UserAccountSimpleDTO> userAccountInfoMap =
        userAccountSimpleList.stream()
            .collect(Collectors.toMap(UserAccountSimpleDTO::getId, Function.identity()));
    List<DynamicInfoDTO> list =
        dynamicList.stream()
            .map(
                d -> {
                  DynamicInfoDTO dynamicInfoDTO = d.buildDynamicInfoDTO();
                  List<ForumResourceDO> forumResourceDOList = ImageMap.get(d.getId());
                  if (CollectionUtils.isNotEmpty(forumResourceDOList)) {
                    dynamicInfoDTO.setMediaVO(
                        forumResourceDOList.stream()
                            .map(ForumResourceDO::buildMedia)
                            .collect(Collectors.toList()));
                  }
                  UserAccountSimpleDTO userAccountSimpleDTO =
                      userAccountInfoMap.get(d.getUserAccountId());
                  if (userAccountSimpleDTO != null) {
                    UserBaseInfoVO userBaseInfoVO = new UserBaseInfoVO();
                    userBaseInfoVO.setNickName(userAccountSimpleDTO.getNickName());
                    userBaseInfoVO.setUserImg(userAccountSimpleDTO.getUserImg());
                    userBaseInfoVO.setUserName(userAccountSimpleDTO.getUserName());
                    userBaseInfoVO.setPhone(userAccountSimpleDTO.getPhoneNum());
                    userBaseInfoVO.setUid(userAccountSimpleDTO.getUid());
                    dynamicInfoDTO.setUserBaseInfo(userBaseInfoVO);
                  }
                  return dynamicInfoDTO;
                })
            .collect(Collectors.toList());
    return PageResult.buildPage(dynamic.getPageNo(), dynamic.getPageSize(), count, list);
  }

  @Override
  public ResultBody deleteDynamic(Integer dynamicId) {
    dynamicDAO.deleteDynamic(dynamicId);
    return ResultBody.success();
  }

  @Override
  public ResultBody hiddenDynamic(Integer dynamicId) {
    dynamicDAO.hiddenDynamic(dynamicId);
    return ResultBody.success();
  }

  @Override
  public ResultBody likeUserInfo(Integer dynamicId, HttpServletRequest request) {
    List<ForumLikeDO> forumLikeList = likeDAO.selectUserAccountId(dynamicId);
    if (forumLikeList != null) {
      List<Integer> list =
          forumLikeList.stream().map(ForumLikeDO::getUserAccountId).collect(Collectors.toList());
      UserAccountQO accountQO = new UserAccountQO();
      accountQO.setUserIds(list);
      List<UserAccountSimpleDTO> userAccountSimpleList =
          userAppApi.feignListAppUserAccount(accountQO, request.getHeader(TokenConstant.TOKEN));
      List<UserBaseInfoVO> userBaseInfoList = new ArrayList<>();
      userAccountSimpleList.forEach(
          d -> {
            UserBaseInfoVO userBaseInfoVO = new UserBaseInfoVO();
            userBaseInfoVO.setNickName(d.getNickName());
            userBaseInfoVO.setUserImg(d.getUserImg());
            userBaseInfoVO.setUserName(d.getUserName());
            userBaseInfoVO.setPhone(d.getPhoneNum());
            userBaseInfoVO.setUid(d.getUid());
            userBaseInfoList.add(userBaseInfoVO);
          });
      return ResultBody.success(userBaseInfoList);
    }
    return ResultBody.success();
  }
}
