package com.mmc.csf.release.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.common.util.web.ResultEnum;
import com.mmc.csf.infomation.dto.UserAccountSimpleDTO;
import com.mmc.csf.infomation.vo.RequirementsInfoVO;
import com.mmc.csf.infomation.vo.RequirementsTypeVO;
import com.mmc.csf.release.dao.RequirementsDao;
import com.mmc.csf.release.entity.RequirementsInfoDO;
import com.mmc.csf.release.entity.RequirementsTypeDO;
import com.mmc.csf.release.feign.UserAppApi;
import com.mmc.csf.release.service.RequirementsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/5/18 14:29
 */
@Slf4j
@Service
public class RequirementsServiceImpl implements RequirementsService {
    @Autowired
    private RequirementsDao requirementsDao;

    @Autowired
    private UserAppApi userAppApi;

    @Override
    public ResultBody listType() {
        List<RequirementsTypeDO> requirementsTypeDOList = requirementsDao.listType();
        List<RequirementsTypeVO> requirementsTypeVOList = requirementsTypeDOList.stream().map(RequirementsTypeDO::buildRequirementsTypeVO).collect(Collectors.toList());
        return ResultBody.success(requirementsTypeVOList);
    }

    @Override
    public ResultBody publish(RequirementsInfoVO requirementsInfoVO) {
        //是否完成认证
        UserAccountSimpleDTO userAccountSimpleDTO = userAppApi.feignGetUserSimpleInfo(requirementsInfoVO.getUserAccountId());
        if (userAccountSimpleDTO == null || !userAccountSimpleDTO.getCompanyAuthStatus().equals("1")){
            return ResultBody.error(ResultEnum.COMPANY_NOT_VERIFY_ERROR);
        }
        RequirementsInfoDO requirementsInfoDO = new RequirementsInfoDO(requirementsInfoVO);
        requirementsDao.addRequirementsInfo(requirementsInfoDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody solveRequire(Integer requirementsInfoId, Integer userAccountId) {
        RequirementsInfoDO requirementsInfoDO = requirementsDao.getRequirementsInfoById(requirementsInfoId);
        if (!requirementsInfoDO.getUserAccountId().toString().equals(userAccountId.toString())){
            return ResultBody.error("无权限");
        }
        requirementsDao.solveRequire(requirementsInfoId);
        return ResultBody.success();
    }
}
