package com.mmc.csf.release.feign;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.dto.UserAccountSimpleDTO;
import com.mmc.csf.release.feign.hystrix.UserAppApiHystrix;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author: zj
 * @Date: 2023/5/18 17:06
 */
@FeignClient(name = "userapp", fallback = UserAppApiHystrix.class)
public interface UserAppApi {
    /**
     * 根据用户id获取基本信息
     * @param userAccountId
     * @return
     */
    @RequestMapping(value = "/userapp/user-account/feignGetUserSimpleInfo", method = RequestMethod.GET)
    public UserAccountSimpleDTO feignGetUserSimpleInfo(@RequestParam Integer userAccountId);
}
