package com.mmc.csf.release.entity.curriculum;

import com.mmc.csf.release.flyer.vo.CurriculumInfoVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;
import java.io.Serializable;

/**
 * 课程基本信息(CurriculumInfoDO)实体类
 *
 * @author makejava
 * @since 2023-05-18 17:37:06
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CurriculumInfoDO implements Serializable {
    private static final long serialVersionUID = 140348746605431718L;
    
    private Integer id;
    /**
     * 课程名称
     */
    private String curriculumName;
    /**
     * 课程供应商（id），用户id
     */
    private Integer supplierId;
    /**
     * 课程价格
     */
    private BigDecimal curriculumPrice;
    /**
     * 课程简介
     */
    private String curriculumDesc;

    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date updateTime;
    /**
     * 是否删除 0：否 1：是
     */
    private Integer deleted;

    private String videoUrl;

    private String surfaceUrl;

    private String detailContent;

    /**
     * 课程类型id
     */
    private Integer categoriesId;

    public CurriculumInfoDO(CurriculumInfoVO curriculumInfoVO) {
        this.id = curriculumInfoVO.getId();
        this.curriculumName = curriculumInfoVO.getCurriculumName();
        this.curriculumDesc = curriculumInfoVO.getCurriculumDesc();
        this.surfaceUrl = curriculumInfoVO.getSurfaceUrl();
        this.detailContent = curriculumInfoVO.getDetailContent();
        this.videoUrl = curriculumInfoVO.getVideoUrl();
        this.categoriesId = curriculumInfoVO.getCategoriesId();
    }

    public CurriculumInfoVO buildCurriculumInfoVO(){
        return CurriculumInfoVO.builder().id(id).curriculumDesc(curriculumDesc).price(curriculumPrice)
                .supplierName("浙江科比特创新科技有限公司").curriculumName(curriculumName)
                .videoUrl(videoUrl).surfaceUrl(this.surfaceUrl).detailContent(this.detailContent)
                .categoriesId(this.categoriesId).build();
    }

}

