package com.mmc.csf.release.controller;

import com.mmc.csf.release.model.group.Create;
import com.mmc.csf.release.model.group.Others;
import com.mmc.csf.release.model.group.Page;
import com.mmc.csf.release.model.group.Update;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.dto.BannerInfoDTO;
import com.mmc.csf.infomation.dto.ModuleInfoDTO;
import com.mmc.csf.infomation.qo.BannerInfoQO;
import com.mmc.csf.infomation.qo.ModuleInfoQO;
import com.mmc.csf.infomation.vo.BannerInfoVO;
import com.mmc.csf.release.flyer.vo.ModuleInfoVO;
import com.mmc.csf.release.service.ModuleInfoService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Author small
 * @Date 2023/5/23 14:11
 * @Version 1.0
 */
@Api(tags = { "宣传中心-接口" })
@RestController
@RequestMapping("/module/")
public class ModuleInfoController {
    @Autowired
    private ModuleInfoService moduleInfoService;

    @ApiOperation(value = "V1.0.1-宣传模块-新增")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("insertModuleInfo")
    public ResultBody insertModuleInfo(@Validated(Create.class) @RequestBody ModuleInfoVO moduleInfoVO) {
        return moduleInfoService.insertModuleInfo(moduleInfoVO);
    }

    @ApiOperation(value = "宣传模块-修改")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("updateModuleInfo")
    public ResultBody updateModuleInfo(@Validated(Update.class) @RequestBody ModuleInfoVO moduleInfoVO) {
        return moduleInfoService.updateModuleInfo(moduleInfoVO);
    }

    @ApiOperation(value = "V1.0.1-删除宣传模块")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @GetMapping("removeModuleInfo")
    public ResultBody removeModuleInfo(@ApiParam(value = "id", required = true) @RequestParam Integer id) {
        return moduleInfoService.removeModuleInfo(id);
    }

    @ApiOperation(value = "修改宣传备注")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @GetMapping("updateModuleInfoRemark")
    public ResultBody updateModuleInfoRemark(@ApiParam(value = "id", required = true) @RequestParam Integer id,
                                             @ApiParam(value = "备注") @RequestParam String remark) {
        return moduleInfoService.updateModuleInfoRemark(id, remark);
    }

    @ApiOperation(value = "V1.0.1-宣传模块管理-分页")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ModuleInfoDTO.class) })
    @PostMapping("listModuleInfoPage")
    public ResultBody<ModuleInfoDTO> listModuleInfoPage(
            @ApiParam(value = "宣传模块查询QO", required = true) @Validated(Page.class) @RequestBody ModuleInfoQO param) {
        return moduleInfoService.listModuleInfoPage(param);
    }

    @ApiOperation(value = "V1.0.1-banner管理-分页")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = BannerInfoDTO.class) })
    @PostMapping("listBannerInfoPage")
    public ResultBody<BannerInfoDTO> listBannerInfoPage(
            @ApiParam(value = "banner查询QO", required = true) @Validated(Page.class) @RequestBody BannerInfoQO param) {
        return moduleInfoService.listBannerInfoPage(param);
    }

    @ApiOperation(value = "删除banner")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @GetMapping("removeBannerInfo")
    public ResultBody removeBannerInfo(@ApiParam(value = "id", required = true) @RequestParam Integer id) {
        return moduleInfoService.removeBannerInfo(id);
    }

    @ApiOperation(value = "V1.0.1-banner-新增")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("insertBannerInfo")
    public ResultBody insertBannerInfo(@Validated(Create.class) @RequestBody BannerInfoVO bannerInfoVO) {
        return moduleInfoService.insertBannerInfo(bannerInfoVO);
    }

    @ApiOperation(value = "V1.0.1-banner-修改")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("updateBannerInfo")
    public ResultBody updateBannerInfo(@Validated(Update.class) @RequestBody BannerInfoVO bannerInfoVO) {
        return moduleInfoService.updateBannerInfo(bannerInfoVO);
    }

    @ApiOperation(value = "V1.0.1-banner-排序交换")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("exchangeBannerInfo")
    public ResultBody exchangeBannerInfo(@Validated(Others.class) @RequestBody List<BannerInfoVO> list) {
        return moduleInfoService.exchangeBannerInfo(list);
    }

    @ApiOperation(value = "获取图片-小程序")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = BannerInfoDTO.class) })
    @GetMapping("listBannerImg")
    public ResultBody listBannerImg(@ApiParam(value = "moduleCode", required = true) @RequestParam String moduleCode) {
        return moduleInfoService.listBannerImg(moduleCode);
    }

    @ApiOperation(value = "V1.0.1-banner批量删除")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("batchRemoveBannerInfo")
    public ResultBody batchRemoveBannerInfo(
            @ApiParam(value = "id数组", required = true,example = "[180,181]") @RequestBody List<Integer> list) {
        return moduleInfoService.batchRemoveBannerInfo(list);
    }

}
