package com.mmc.csf.release.industry;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Author small
 * @Date 2023/8/18 13:40
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CompanyInspectionDTO implements Serializable {
    private static final long serialVersionUID = -7994243059824987869L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "单位id")
    private Integer companyInfoId;
    @ApiModelProperty(value = "服务范围")
    private String serviceArea;
    @ApiModelProperty(value = "服务id")
    private Integer inspectionId;
    @ApiModelProperty(value = "服务标签")
    private Integer inspectionTagId;
    @ApiModelProperty(value = "报价")
    private BigDecimal price;
    @ApiModelProperty(value = "报价说明")
    private String priceRemark;
    @ApiModelProperty(value = "价格单位")
    private Integer inspectionPriceUnitId;
    @ApiModelProperty(value = "详情页")
    private String detailPage;
    @ApiModelProperty(value = "销售状态，0停售，1在售")
    private Integer saleState;
    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "服务主图")
    private String inspectionFirstImg;
    @ApiModelProperty(value = "作业团队")
    private String CompanyName;

    @ApiModelProperty(value = "行业")
    private IndustryTypeDTO industryTypeDTO;
    @ApiModelProperty(value = "服务")
    private InspectionDTO inspectionDTO;
    @ApiModelProperty(value = "团队服务标签")
    private InspectionTagDTO inspectionTagDTO;
    @ApiModelProperty(value = "团队服务图片/视频")
    private List<CompanyInspectionFileDTO> inspectionFileDTOS;


}
