package com.mmc.csf.release.entity;

import com.mmc.csf.release.task.vo.IndustryVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.io.Serializable;

/**
 * 行业管理(IndustryDO)实体类
 *
 * @author makejava
 * @since 2023-05-19 09:51:16
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class IndustryDO implements Serializable {
    private static final long serialVersionUID = -43925052782251392L;
    
    private Integer id;
    /**
     * 行业名称
     */
    private String name;
    /**
     * 行业图标
     */
    private String industryIcon;
    /**
     * 简称
     */
    private String shortName;
    /**
     * 0飞行服务，1个人服务，2设备售卖，3设备租赁，4设备返祖
     */
    private Integer industryType;
    /**
     * 行业宣传语1
     */
    private String propagate1;
    /**
     * 行业宣传语2
     */
    private String propagate2;
    /**
     * 图片地址
     */
    private String image;
    /**
     * 视频地址
     */
    private String video;
    /**
     * 是否删除  0 未删除  1 删除
     */
    private Integer del;
    
    private Date updateTime;
    
    private Date addTime;
    /**
     * 行业编号
     */
    private String number;
    
    private Integer sort;
    /**
     * 是否上架   1上架  0下架
     */
    private Integer shelf;
    /**
     * 是否是演示专用行业：0：否 1：是
     */
    private Integer demons;


    public IndustryVO buildIndustryVO(){
        return IndustryVO.builder()
                .id(this.id)
                .industryIcon(this.industryIcon)
                .name(this.name)
                .shortName(this.shortName)
                .industryType(this.industryType)
                .propagate1(this.propagate1)
                .propagate2(this.propagate2)
                .image(this.image)
                .video(this.video).build();
    }


}

