package com.mmc.csf.release.entity.curriculum;

import com.mmc.csf.release.flyer.vo.CurriculumClassifyVO;
import com.mmc.csf.release.flyer.vo.CurriculumInfoVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 课程基本信息(CurriculumClassifyDO)实体类
 *
 * @author han
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CurriculumClassifyDO implements Serializable {
    private static final long serialVersionUID = 140348746605431718L;

    private Integer id;

    /**
     * 课程类别名称
     */
    private String name;
    /**
     * 1级课程分类
     */
    private Integer oneCourseId;
    /**
     * 2级课程分类
     */
    private Integer twoCourseId;
    /**
     * 分类图标
     */
    private String classifyUrl;
    /**
     * 分类描述
     */
    private String classifyDesc;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date updateTime;
    /**
     * 是否删除 0：否 1：是
     */
    private Integer deleted;


    public CurriculumClassifyDO(CurriculumClassifyVO curriculumClassifyVO) {
        this.id = curriculumClassifyVO.getId();
        this.name = curriculumClassifyVO.getName();
        this.oneCourseId = curriculumClassifyVO.getOneCourseId();
        this.twoCourseId = curriculumClassifyVO.getTwoCourseId();
        this.classifyUrl = curriculumClassifyVO.getClassifyUrl();
        this.classifyDesc = curriculumClassifyVO.getClassifyDesc();
    }

    public CurriculumClassifyVO buildCurriculumClassifyVO(){
        return CurriculumClassifyVO.builder().id(id).name(name)
                .oneCourseId(oneCourseId).twoCourseId(twoCourseId)
                .classifyUrl(classifyUrl).classifyDesc(classifyDesc)
                .createTime(createTime).updateTime(updateTime).build();
    }

}

