package com.mmc.csf.release.entity.requirements;

import com.mmc.csf.infomation.dto.ServiceArriveSceneDTO;
import com.mmc.csf.infomation.vo.ServiceArriveSceneVO;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;

/**
 * @Author small
 * @Date 2023/8/18 19:29
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class ServiceArriveSceneDO {
    @ApiModelProperty(value = "id")
    @NotNull(message = "id不能为空", groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "id")
    private Double longitude;

    @ApiModelProperty(value = "id")
    private Double latitude;

    @ApiModelProperty(value = "现场地址")
    private String sceneAddress;

    @ApiModelProperty(value = "现场地址的url", required = true)
    private String sceneUrl;

    @ApiModelProperty(value = "现场用户id", hidden = true)
    private Integer userAccountId;

    @ApiModelProperty(value = "服务需求id", required = true)
    private Integer requirementsInfoId;

    public ServiceArriveSceneDO(ServiceArriveSceneVO serviceArriveSceneVO) {
        this.longitude = serviceArriveSceneVO.getLongitude();
        this.latitude = serviceArriveSceneVO.getLatitude();
        this.sceneAddress = serviceArriveSceneVO.getSceneAddress();
        this.sceneUrl = serviceArriveSceneVO.getSceneUrl();
        this.userAccountId = serviceArriveSceneVO.getUserAccountId();
        this.requirementsInfoId = serviceArriveSceneVO.getRequirementsInfoId();
    }

    public ServiceArriveSceneDTO buildServiceArriveSceneDTO() {
        return ServiceArriveSceneDTO
                .builder()
                .longitude(this.longitude)
                .latitude(this.latitude)
                .sceneAddress(this.sceneAddress)
                .sceneUrl(this.sceneUrl)
                .userAccountId(this.userAccountId)
                .requirementsInfoId(this.requirementsInfoId)
                .build();
    }

}
