package com.mmc.csf.infomation.dto;

import com.mmc.csf.release.model.group.Insert;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Author small
 * @Date 2023/8/29 10:31
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ServiceOrderFormDTO {
    private static final long serialVersionUID = -447951390213113317L;
    @ApiModelProperty(value = "id")
    @NotNull(message = "id不能为空", groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "服务类型id", example = "1")
    @NotBlank(message = "服务类型id不能为空", groups = {Insert.class, Update.class})
    private Integer serviceId;

    @ApiModelProperty(value = "服务类型名称", example = "航拍摄影")
    private String serviceName;

    @ApiModelProperty(value = "订单级别 REGULAR_ORDER,RUSH_ORDER,TOP_ORDER", example = "TOP_ORDER")
    private String orderLevel;

    @ApiModelProperty(value = "发布者订单编号", example = "R3123132132132131")
    private String publisherNumber;

    @ApiModelProperty(value = "发布者电话", example = "1892994543", required = false)
    private String publishPhone;

    @ApiModelProperty(value = "抢单者电话", example = "13134311231")
    private String preemptPhone;

    @ApiModelProperty(value = "订单当前状态", example = "进行中")
    private String doing;

    @ApiModelProperty(value = "1正常 2争议订单", example = "1")
    private Integer orderAttribute;

    @ApiModelProperty(value = "平台总收益", example = "100")
    private BigDecimal orderEarnings;
    @ApiModelProperty(value = "发单时间", example = "")
    private String createTime;

    @ApiModelProperty(value = "更新时间", example = "")
    private String updateTime;

    @ApiModelProperty(value = "状态", example = "100")
    private String orderStatus;

    @ApiModelProperty(value = "等待状态", example = "等待状态")
    private String waiting;

    @ApiModelProperty(value = "父订单id")
    private Integer fatherRequireId;

    @ApiModelProperty(value = "子订单详情")
    private List<ServiceOrderFormDTO> childrenRequire;

    @ApiModelProperty(value = "发布者基本信息")
    private UserBaseInfoDTO orderRelease;

    @ApiModelProperty(value = "接单人基本信息")
    private UserBaseInfoDTO orderReceive;
}
