package com.mmc.csf.release.controller;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.vo.IndustryCaseVO;
import com.mmc.csf.infomation.vo.IndustryNewsVO;
import com.mmc.csf.release.model.group.Page;
import com.mmc.csf.release.service.IndustryNewsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author: zj
 * @Date: 2023/5/19 10:42
 */
@Api(tags = {"行业新闻相关"})
@RestController
@RequestMapping("/industry-news/")
public class IndustryNewsController {
    @Autowired
    private IndustryNewsService industryNewsService;

    @ApiOperation(value = "新闻列表")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = IndustryNewsVO.class) })
    @PostMapping("listNewsPage")
    public ResultBody listNewsPage(@Validated(value = {Page.class})@RequestBody IndustryCaseQO industryCaseQO){
        return industryNewsService.listNewsPage(industryCaseQO);
    }

    @ApiOperation(value = "案例详情")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = IndustryNewsVO.class) })
    @GetMapping("details")
    public ResultBody details(@RequestParam Integer id){
        return industryNewsService.details(id);
    }
}
