package com.mmc.csf.common.util.web;

/**
 * @author 作者 geDuo
 * @version 创建时间：2021年8月13日 上午9:29:58
 * @explain 类说明
 */
public enum ResultEnum implements BaseErrorInfoInterface {

    // 数据操作错误定义
    SUCCESS("200", "success"), BODY_NOT_MATCH("400", "请求的数据格式不符!"), SIGNATURE_NOT_MATCH("401", "请求的数字签名不匹配!"),
    NOT_FOUND("404", "未找到该资源!"), INTERNAL_SERVER_ERROR("500", "服务器内部错误!"), SERVER_BUSY("503", "服务器正忙，请稍后再试!"),
    FILE_UPLOAD_ERROR("600", "文件上传有误"), FILE_UPLOAD_NULL_ERROR("601", "上传的文件不能为空"),
    TOKEN_EXPIRED_ERROR("602", "登录信息已过期，请重新登录"), TOKEN_INVALID_ERROR("603", "无效的登录信息"),
    VERIFY_CODE_ERROR("604", "验证码错误，请重新输入"), TOKEN_REDIS_ERROR("605", "登录失效"),
    AUTH_ACCOUNT_ERROR("606", "当前账号未授权，请先授权"), TOEKN_REPEAT_ERROR("607", "该账号已在其他设备登录，请重新登录"),
    TOKEN_NOT_VALID_ERROR("608", "access_token已失效或access_token不是最新的"),
    SCHEDULE_SYS_ERROR("703", "系统定时任务执行错误"),
    FORM_REPEAT_ERROR("704", "操作次数频繁，请稍后重试"), DATA_VERSION_ERROR("705", "数据写入版本不一致，请稍后重试。"),
    REQUEST_PARAM_ILLEGAL_ERROR("706", "请求参数非法"),
    DATA_INSERT_ERROR("707", "数据插入失败"),
    SCORE_RELEASE_ERROR("708", "积分发放失败，请重试或联系管理员！"),
    ENTRY_INTO_FORCE_TIME_SET_ERROR("709", "生效时间不能小于当前时间！"),
    INFO_NO_EXISTENCE_OR_STATUS_ERROR("710", "信息不存在或状态有误！"),

    // 业务操作错误定义
    CUSTOM_ERROR("-1", "自定义业务错误消息"),
    FEIGN_ORDER_SERVLET_ERROR("4001", "访问订单服务失败"), FEIGN_USER_SERVLET_ERROR("4002", "访问用户服务失败"),
    FEIGN_PAY_SERVLET_ERROR("4003", "访问消耗服务失败"),
    DISABLE_ACCOUNT_TOKEN_ERROR("4004", "账号信息变更，登录失效"),
    FEIGN_OPERATION_SERVLET_ERROR("4005", "访问行业服务失败"),
    ADMIN_ROLE_REPEAT_ERROR("4006", "操作失败，超级管理员和运营管理员有且只有一个"),
    FEIGN_FLYER_SERVLET_ERROR("4007", "访问飞手服务失败"),
    FEIGN_REPOORDER_SERVLET_ERROR("4008", "访问订单服务失败"),
    FEIGN_REPOPAY_SERVLET_ERROR("4009", "访问云仓消耗服务失败"),
    FEIGN_REPOUSER_SERVLET_ERROR("4010", "访问云仓用户服务失败"),
    FEIGN_WARE_SERVLET_ERROR("4010", "访问云仓商品服务失败"),
    FEIGN_DEVICE_SERVLET_ERROR("4011", "访问云仓设备服务失败"),
    CENTER_USER_SERVLET_ERROR("4012", "访问用户中心服务失败"), GATEWAY_HYSRIX_ERROR("4013", "服务器貌似在开小差~"),
    FEIGN_FLYER_PAY_SERVLET_ERROR("4014", "访问飞手消耗服务失败"),
    MALL_USER_SERVLET_ERROR("4015", "访问机城用户服务失败"),
    PRIMARY_KEY_DEFECT("5001", "主键ID缺失"),
    WALLET_NOT_FIND_ERROR("5002", "钱包账户不存在"),
    PARAM_DEFECT("5004", "参数缺失"),
    LOGIN_ACCOUNT_NOT_EXIT_ERROR("5005", "账号不存在"),
    LOGIN_PASSWORD_ERROR("5006", "密码错误"),
    LOGIN_ACCOUNT_STATUS_ERROR("5008", "未登录"),
    OPERATE_USER_ORDERCOUNT_ERROR("5007", "当前账号有存在相关订单未关闭"),
    WALLET_CASH_NOT_ENOUGH_ERROR("5009", "现金余额不足"),

    AMT_PAID_VERITY_ERROR("5010", "变更额度不在有效范围"),
    CREDIT_NOT_ENOUGH_ERROR("5011", "信用余额不足，当前信用余额："),
    CREDIT_METHOD_ERROR("5012", "变更类型有误"),
    CREDIT_OWED_BEGGER_ERROR("5013", "归还额度不可超过剩余欠款，当前剩余欠款："),
    CASH_ADD_OWED_ERROR("5014", "该账号仍有剩余欠款，请先将全部欠款归还后，再进行充值。"),
    WALLET_CREDIT_NOT_ENOUGH_ERROR("5015", "信用余额不足"),
    ORDER_PAY_FORMAT_ERROR("5016", "现金和信用金额不能同时为空"),
    WALLET_CASH_FREEZE_NOT_ENOUGH_ERROR("5017", "现金的冻结余额不足"),
    WALLET_CREDIT_FREEZE_NOT_ENOUGH_ERROR("5018", "信用的冻结余额不足"),
    ORDER_CASH_FREEZE_NOT_FIND_ERROR("5019", "现金的冻结余额不存在"),
    ORDER_CREDIT_FREEZE_NOT_FIND_ERROR("5019", "信用的冻结余额不存在"),
    WALLET_BANLANCE_NOT_ENOUGH_ERROR("5020", "现金和信用的余额不足"),
    WALLET_FREEZE_NOT_ENOUGH_ERROR("5020", "现金和信用的冻结余额不足"),
    CREDIT_REPEAT_NULL_ERROR("5021", "欠款归还不能为空"),
    CREDIT_CHANGE_NULL_ERROR("5021", "信用余额变更不能为空"),
    ORDER_TOTAL_COST_ERROR("5022", "结算金额不能大于预支付的金额"),
    ORDER_PAY_NOT_ENOUGH_ERROR("5023", "总余额不足，订单无法结算"),
    NOT_MENU_POWER_ERROR("5024", "当前账号无平台使用权限"),
    OPENID_NOT_FIND_ERROR("5025", "OPENID未注册，请登录授权后调用"),
    PASSWORD_INCONSISTENT("5026", "新密码与确认密码不一致，请确认一致"),
    WX_ACCESS_TOKEN_ERROR("5027", "获取微信AccessToken失败"),
    WX_NOT_REL_ERROR("5028", "获取微信公众号用户信息失败"),
    WX_NOT_SEND_MSG_PARAM_ERROR("5029", "userId和openId至少一个不为空"),
    APPLET_QR_CODE_CREATE_ERROR("5030", "生成小程序码错误："),
    APPLET_USER_ACCESS_TOKE_ERROR("5031", "获取accessToken签名校验失败"),
    REBATE_AMT_NOT_MIN_ERROR("5032", "金额不足300元无法提现，300元为最低门槛"),
    REBATE_AMT_NOT_ENOUGH_ERROR("5033", "申请失败，超过可提现的金额"),
    BANK_INFO_NOT_SAVE_ERROR("5034", "请先完善收款账号，才可以申请提现"),
    REBATE_APPLY_STATUS_ERROR("5035", "提现状态有误"),
    REBATE_INFO_NOT_FIND_ERROR("5036", "提现申请单信息不存在"),
    REBATE_FAIL_EXIT_ERROR("5037", "你的收款账号信息有误，请修改信息后重新申请提现。"),
    REBATE_AMT_FORMAT_ERROR("5038", "提现金额必须大于0元"),
    REBATE_REPEAT_CHECK_ERROR("5039", "提现申请单已被审批，切勿重复审批。"),
    CHOOSE_FLYER_NUM_ERROR("5040", "请至少选中一个飞手。"),
    CHOOSE_FLYER_MORE_NUM_ERROR("5041", "暂只支持一个订单只能指派一个飞手。"),
    ORDER_NO_EXIT_ERROR("5042", "订单信息不存在。"),
    ORDER_STATUS_ERROR("5043", "订单状态流程有误。"),
    INTERFACE_NOT_INVAILD("5044", "接口已废弃或不存在"),
    PAPER_CODE_NOT_INVAILD("5045", "接口已废弃或不存在"),
    PHONE_INVAILD_ERROR("5046", "无效的手机号"),
    TIME_CODE_INVAILD_ERROR("5047", "无效的时间编码"),
    REPEACT_COMMIT_ERROR("5048", "已提交，切勿重复提交"),
    IMPORT_EXCEL_ERROR("5049", "excel导入失败"),
    REQ_SMS_CODE_ERROR("5050", "注册码格式有误"),
    SKU_NOT_PRICE_ERROR("5051", "当前SKU未配置价格"),
    SKU_NOT_ENOUGH_ERROR("5052", "套餐（sku）数量不足"),

    LEASE_DATE_MATH_ERROR("5053", "租期开始日不能大于结束日"),
    ADD_LEASE_ADDR_ERROR("5054", "请选择收货方式"),
    SHOP_NEED_PHONE_ERROR("5055", "门店自取需要您的联系电话，请填写联系电话"),
    ORDER_POWER_ERROR("5056", "订单不存在或你无权操作该订单"),
    ORDER_AUTH_ERROR("5057", "请完成认证再下单"),
    EXPRESS_RETURN_ERROR("5058", "请完善物流单号和物流公司"),
    SHOP_RETURN_ERROR("5059", "请选择门店"),
    ORDER_REFUND_EXIT_ERROR("5060", "该订单已提交过退款申请，请勿重复申请。"),
    ORDER_EXPRESS_ERROR("5061", "获取订单物流信息有误。"),
    ORDER_PAY_JOB_ERROR("5062", "执行定时任务有误"),
    NO_AUTH_ORDER_ERROR("5063", "请完成企业认证或实名认证后再进行下单"),
    WARE_NOT_ENOUGH_ERROR("5064", "商品数量不足"),
    EX_INFO_ERROR("5065", "物流信息不完善"),
    NOT_REAL_AUTH_ERROR("5066", "请完成实名认证后再进行操作"),
    REBATE_NOT_ENOUGH_ERROR("5067", "提现申请金额需在10至8000元范围之内"),
    MORE_THAN_LIMIT_ERROR("5067", "提现申请金额需在0.1至98000元范围之内"),
    FLYER_ENT_MORE_THAN_LIMIT_ERROR("50670", "飞手机构用户银行卡单笔最低10元，最高100,000元"),
    FLYER_MORE_THAN_LIMIT_ERROR("50671", "飞手个人用户银行卡单笔最低10元，最高5,000元"),
    MORE_THAN_LIMIT_TODAY_ERROR("50672", "单个账户每月提现额度为100,000元"),
    SYSTEM_AMT_NOT_ENOUGH_ERROR("5068", "系统处理中，请稍后再试。"),
    FEIGN_XZH_SERVLET_ERROR("5069", "访问线上支付接口服务失败"),
    XZH_SERVLET_ERROR("5070", "调用线上支付失败："),
    XZH_FAIL_ERROR("5071", "支付服务失败："),
    REFUSE_COUNT_ERROR("5072", "今日拒绝的次数已达上限，暂不可参与抢单"),
    APPLY_ORDER_COUNT_ERROR("5073", "请勿重复接单"),
    ORDER_ARRIVE_ERROR("5074", "抢单失败，订单已被指派"),
    REST_APPLY_ORDER_ERROR("5075", "请先开启接单状态后再进行抢单"),
    EVALUATED_ERROR("5076", "您已经评价过啦!"),
    BACKET_TYPE_ERROR("5077", "红包类型有误"),
    BACKET_NOT_ENOUGH_ERROR("5078", "红包已被抢光"),
    USER_PHONE_AUTH_ERROR("5079", "请授权登录后领取"),
    TOKEN_REQUIRED_ERROR("5080", "Please bring a token"),
    UNIONID_NOT_ERROR("5081", "UnionId不能为空"),
    OPENID_NOT_ERROR("5081", "云享飞openid、云飞手openid、云仓openid、无人机城openid至少要有一个"),
    NO_EVALUATED_ERROR("5090", "暂无评价信息!"),
    DAY_NUM_ERROR("5091", "天数有误"),
    TASK_TYPE_ERROR("5092", "您的账号类型为个人飞手，只能抢任务人数1人的订单。"),
    TASK_FLYER_COUNT_LESS_ERROR("5093", "机构认证的飞手多于任务需要的飞手才可以抢单。"),
    FLYER_REBATE_ERROR("5094", "提现失败，请稍后重试"),
    OPERATION_SYS_ERROR("5095", "操作失败，请稍后重试"),
    WAG_CHECK_STATUS_ERROR("5096", "操作失败，未通过或待确认状态才能进行重新编辑"),
    EXPORT_NO_DATA_ERROR("5097", "查询到当前符合条件的数据为0条"),
    WAG_ZERO_ERROR("5098", "工资抵扣后当月工资不能少于0元"),
    WAG_REPEAT_DATE_ERROR("5099", "操作失败，工资日期重复："),

    BUY_NUM_ERROR("5100", "购买数量必须大于0"),
    SHOP_CAR_ERROR("5101", "购物车信息不存在"),
    GOODS_VERSION_ERROR("5102", "操作失败，当前商品已经发生信息变更，请刷新后重试"),
    WAG_DETAIL_COUNT_ERROR("5103", "账单天数必须大于0"),
    WAG_TERM_PARAM_ERROR("5104", "飞手工资、结算基数、操作三个选项必须填一个"),
    IMPORT_PARAM_ERROR("5105", "导入的数据行不能为空或者格式错误"),
    SHOP_GOODS_NOT_ERROR("5106", "当前商品已下架或已删除"),
    ALL_PAY_ERROR("5107", "当前订单为分期付款，请先上传尾款凭证"),
    FLYER_EVLT_PARAM_ERROR("5108", "飞手评分参数有误，请检查"),
    FLYER_REPEAT_BIND_ERROR("5108", "飞手已被绑定过，请勿重复绑定"),
    FLYER_NUM_BIND_ERROR("5108", "飞手数量有误，本任务需要的飞手人数为："),
    FLYER_ORDER_TYPE_ERROR("5110", "飞手类型有误，该订单只允许个人飞手接单"),
    FLYER_ENT_ORDER_TYPE_ERROR("5111", "飞手类型有误，该订单只允许飞手机构接单"),
    PHONE_NUM_EXIT_ERROR("5112", "手机号已存在"),
    FLYER_UN_BIND_ERROR("5113", "飞手已被解绑，请勿重复解绑"),
    REPEAT_NOTIFICATION("5114", "您已对此订单进行过催付款操作"),
    FLYER_WORK_ERROR("5115", "指派飞手失败，飞手休息中："),
    DISABLE_APPLY_ORDER_ERROR("5116", "当前时间此订单不可抢"),

    COMPANY_EXIT_ERROR("5117", "单位名称已存在"),
    COMPANY_NOT_BIND_ERROR("5118", "未绑定单位，请先绑定单位"),
    COMPANY_REMOVE_ERROR("5119", "删除失败，请先移除该单位的账号信息"),
    COMPANY_REMOVE_CHILD_ERROR("5120", "删除失败，请先移除该单位的子级单位"),
    EXIST_THE_SAME_GOODS_ERROR("5121", "购物车已存在您选择的商品"),

    // clientOAuth
    OAUTH_CLIENT_NOT_FOUND("6404", "client_id不存在或已注销"),
    OAUTH_SECRET_ERROR("6405", "client_secret有误"),
    OAUTH_AUTHORIZE_ERROR("6406", "当前账号未获得任何授权，请确认"),
    OAUTH_API_AUTH_ERROR("6407", "当前资源未被授权"),
    OAUTH_CREATE_TOKEN_ERROR("6408", "系统内部错误，获取accessToken失败，"),

    PWD_CREATE_ERROR("6001", "创建密码失败"),
    PWD_CONPARED_ERROR("6002", "密码错误"), PWD_ALERT_ERROR("6003", "密码不一致"),
    PWD_REQUEST_AUTH_ERROR("6003", "密码请求验证"),
    APPLET_PORT_TYPE_ERROR("7001", "小程序端口类型错误"),
    APPLET_GET_OPENID_ERROR("7002", "获取小程序openid失败"),
    UPDATE_USER_ACCOUNT_REPEAT("7003", "修改后的账户名已存在"), ADD_USER_ACCOUNT_NAME_EXISTS("7004", "新增账户名已经存在"),
    ACCOUNT_NOT_FIND_ERROR("8000", "账号信息不存在"),
    REPEAT_SOFT_DELETE("8001", "账号已删除"),
    ADMIN_ROLE_DELETE_ERROR("8002", "此账号为管理员账号，禁止删除"),
    ROLE_ADMIN_DELETE_ERROR("8003", "此角色为管理员角色，禁止删除"),
    ROLE_NAME_REPEAT_ERROR("8004", "角色名已存在"),
    ROLE_AVL_USER_DELETE_ERROR("8005", "此角色尚有可用账号，请将所有账号移除后在进行操作"),
    ROLE_AVL_USER_STATUS_ERROR("8006", "此角色尚有可用账号，请将所有账号禁用后在进行操作"),
    ROLE_SYSTEM_DELETE_ERROR("8007", "此角色为系统角色，禁止删除"),
    ADMIN_ROLE_POWER_ERROR("8008", "禁止修改管理类角色权限"), SYSTEM_ROLE_POWER_ERROR("8009", "禁止修改系统类角色权限"),
    ROLE_SELF_POWER_ERROR("8010", "禁止修改与当前登录账号角色相同的角色权限"),
    ADMIN_ACCOUNT_DISABLE_ERROR("8011", "此账号为管理员账号，禁用失败"),

    OPERATE_USER_DEL_ERROR("8012", "该账号仍有进行中的订单需要负责，请先移交订单后再删除。"),
    OPERATE_USER_DISABLED_ERROR("8013", "该账号仍有进行中的订单需要负责，请先移交订单后再禁用。"),

    DELETE_USER_UNFILLED_ORDER_EXIST("9001", "平台中有此账号相关的订单，不可删除此账号"),
    STOP_UNFILLED_ORDER_EXIST("9002", "平台中有此账号相关的订单正在进行中，不可停用此账号"),
    ACCOUNT_ALREADY_DELETED("10001", "此账号已经被删除"),
    ACCOUNT_ALREADY_STOP("10002", "此账号已经被停用,不能登录此小程序，详情请联系管理员"),

    INDUSTRY_NAME_CREATE_ERROR("20001", "行业名称请勿重复，请重新输入"),
    INSPECTION_NAME_CREATE_ERROR("20002", "服务名称请勿重复，请重新输入"),
    INSPECTION_REPEAT("20003", "绑定服务重复"),
    INDUSTRY_REPEAT("20004", "绑定行业重复"),

    INSERT_INDUSTRY_SUCCESS("20005", "新增行业成功"),
    UPDATE_INDUSTRY_SUCCESS("20006", "修改行业成功"),
    DELETE_INDUSTRY_SUCCESS("20007", "删除行业成功"),
    INSERT_INSPECTION_SUCCESS("20008", "新增服务成功"),
    UPDATE_INSPECTION_SUCCESS("20009", "修改服务成功"),
    DELETE_INSPECTION_SUCCESS("20010", "删除服务成功"),
    SORT_PARAMETER_ERROR("28199", "排序参数错误"),
    OPRATING_FREQUENCY_TOO_HIGH("28449", "更新频率过快,请重试"),


    INSERT_INDUSTRY_INSPECTION_SUCCESS("20011", "添加对应服务成功"),
    INSERT_INSPECTION_INDUSTRY_SUCCESS("20012", "添加对应行业成功"),
    DELETE_INDUSTRY_INSPECTION_SUCCESS("20013", "删除对应服务成功"),
    DELETE_INSPECTION_INDUSTRY_SUCCESS("20014", "删除对应行业成功"),

    INSERT_INDUSTRY_SHELF_SUCCESS("20015", "行业上架成功"),
    DELETE_INDUSTRY_SHELF_SUCCESS("20016", "行业下架成功"),

    INSERT_INSPECTION_SHELF_SUCCESS("20017", "服务上架成功"),
    DELETE_INSPECTION_SHELF_SUCCESS("20018", "服务下架成功"),

    DELETE_INSPECTION_ERROR("20022", "该服务仍有未完成的订单，不可删除"),

    INSPECTION_NOT_EXIST("20023", "很抱歉，目前该服务已下架"),
    FAKE_NUM_CREATE_ERROR("20024", "输入的数据有误，请重新输入！"),
    WORK_TYPE_NAME_ERROR("20026", "服务作业类型重复，请重新输入"),
    EXIST_BINDING_INSPECTION_ERROR("20027", "此作业类型被服务绑定，删除失败！"),

    UPLOAD_IMG_ERROR("20019", "请选择jpg,png,jpeg格式的图片"),
    UPLOAD_VIDEO_ERROR("20020", "请选择MP4,avi,mov,mkv格式的视频"),
    UPLOAD_DOC_ERROR("20021", "请选择doc,ppt,pdf,xls格式的文件"),
    UPLOAD_IMG_LESS_3M_ERROR("20022", "请上传小于3M的图片"),

    INSERT_ORDER_SUCCESS("21000", "新增订单成功"),
    UPDATE_ORDER_SUCCESS("21001", "修改订单成功"),
    ORDER_TRANS_SUCCESS("21002", "订单移交成功"),
    ORDER_EVALUATE_SUCCESS("21003", "订单评价完成"),
    ORDER_BEFORE_PAY_ERROR("21004", "订单预支付失败"),
    ORDER_CLOSE_PAY_ERROR("21005", "订单结算支付失败"),
    INSERT_ORDER_DETAIL_SUCCESS("21006", "新增订单动态成功"),

    CHECK_USER_ERROR("22001", "用户未通过验证"),

    GET_ORDER_LIST_ERROR("22002", "获取订单列表失败"),
    COMMANT_CAR_NAME_EXIST("22003", "指挥车名字已存在，请重新输入"),


    //认证提示
    APP_CODE_ERROR("30301", "appcode 错误"),
    REQUE_ENVIROMENT_ERROR("30302", "请求的 Method、Path 或者环境错误"),
    REQUEST_PARAMETER_ERROR("30303", "请求参数错误"),
    SERVICE_NOT_AUTHORIZED("30304", "服务未被授权（或URL和Path不正确）"),
    TIMES_USED_UP("30305", "很抱歉，目前我们的实名认证次数已达上限，正在处理中，请稍后再进行认证。"),
    OTHER_ERROR("30306", "其他错误/服务次数用完"),
    LIVE_AUTHENTICATION_FAILED("3824", "活体认证失败"),
    ID_INFO_AND_ID_card_MISMATCH("3904", "身份信息与身份证不匹配"),
    LIVE_AUTHENTICATION_SUCESS("3999", "活体验证成功"),
    NO_REAL_NAME("3854", "用户未实名认证"),
    URL_FORMAT_ERROR("37462", "URL格式错误"),
    URL_ADDRESS_ERROR("36752", "URL地址错误"),
    INTERFACE_ACCESS_EXCEPTION("36894", "接口访问异常/次数用尽"),
    FRONT_BACK_VAGUE("35556", "身份证正反面不明确"),
    ID_CARD_THOTO_MESSAGE_ERROR("36651", "身份照信息错误"),
    EXPTION_ID_CARD_THOTO_MESSAGE_ERROR("36651", "信息异常"),
    PHOTO_FORMAT_ERROR("12138", "身份证图片格式错误"),
    VALIDATION_INFO_EXPIRED("32815", "认证时间过长信息过期或认证信息不完整，请重新开始认证"),
    REAL_IMAGE_AUTHENTICATION_SUCESS("38844", "验证成功"),
    REAL_IMAGE_AUTHENTICATION_FAILED("38855", "验证失败，请再次进行人脸识别"),
    IDENTITY_HAS_BEEN_AUTHENTICATED("34444", "此身份证信息已经被认证，请重试"),
    REAL_NAME_ACCOUNT_ID_ERROR("36771", "账户id错误"),
    REAL_NAME_FUSING_ERROR("36772", "认证失败，请重新认证"),

    //企业认证
    BUSINESS_LICENSE_CHECK_ANALYSIS_ERROR("30400", "营业执照解析失败，请上传有效清晰的执照"),
    BUSINESS_LICENSE_CHECK_PARAMETER_ERROR("30401", "企业信息与营业执照信息不一致，请重新上传"),
    BANK_ACCOUNT_CHECK1_ERROR("30402", "账号与开户名不符"),
    BANK_ACCOUNT_CHECK2_ERROR("30403", "开户行名称错误"),
    BANK_ACCOUNT_CHECK3_ERROR("30404", "仅支持对公账户验证，不支持个人卡"),
    BANK_ACCOUNT_CHECK4_ERROR("30405", "企业账号信息有误，请重新输入"),
    BANK_ACCOUNT_CHECK5_ERROR("30406", "24小时之内不能重复申请"),
    BANK_ACCOUNT_CHECK6_ERROR("30407", "很抱歉，目前我们的企业认证次数已达上限，如需继续认证请及时联系相关负责人进行处理，联系方式：科比特管理人员，18938853647。"),
    BANK_ACCOUNT_CHECK7_ERROR("30408", "企业名称与开户名称不一致，请确认一致后再提交认证"),
    ENTERPRISE_HAVE_VERIFIED("30409", "您输入的企业信息已被其他用户认证，请重新输入"),

    ID_NUMBER_PARA_ERROR("30410", "身份证号码有错，请重新输入"),
    DEAL_ERROR("30411", "有报错，请联系平台客服。"),
    NOT_DATA_ERROR("30412", "查无数据"),
    API_STOP_USE_ERROR("30413", "接口停用"),
    OFFICE_DATA_SUSTAIN_ERROR("30414", "官方数据源维护，请稍候再试"),
    SERVER_SUSTAIN_ERROR("30415", "服务商维护，请稍候再试"),
    PARA_ERROR("30416", "参数错误，请重新输入"),
    VERIFY_COUNT_ERROR("30416", "认证次数上限，请联系管理员"),
    NOT_ENT_VERIFY_ERROR("30417", "机构未认证或认证未通过，请先进行机构认证"),
    NOT__VERIFY_ERROR("30418", "机构未认证或飞手认证未通过，请先进行认证"),
    COMPANY_NOT_VERIFY_ERROR("30419", "未进行企业认证"),

    //渠道认证
    NOT_ENT_USER("30501", "感谢您有意向成为我们的渠道商，请先完成企业认证。"),
    NEW_NOT_ENT_USER("30502", "此用户未进行企业认证，渠道变更失败！"),
    BEFORE_NOT_CHANNEL_USER("30503", "此用户还不是渠道"),


    //飞手端认证
    NOT_AUTH_FLYER_ERROR("30600", "飞手未认证，请先完成飞手认证"),
    NOT_HAVE_AUTH_FLYER_ERROR("30601", "没有认证的飞手，暂不可接单"),

    //设备型号提醒
    DEVICE_MODEL_REPEAT_ERROR("30700", "产品名称不可重复，请重新输入"),
    DEVICE_MODEL_FAILURE_ERROR("30701", "设备添加失败"),
    DEVICE_MODEL_REMOVE_ERROR("30702", "设备未在仓库，删除失败"),
    DEVICE_MODEL_UPDATE_ERROR("30703", "设备修改失败"),
    DEVICE_HAS_BEEN_RENT_ERROR("30704", "该设备不在仓库，不能出库"),

    //仓库提醒
    REPO_INFO_NAME("30800", "仓库名称不可重复，请重新输入"),
    REPO_INFO_FAILURE("30801", "仓库添加失败"),
    REPO_INFO_REMOVE("30702", "仓库删除失败"),

    //商品
    WARE_NAME_HAS_BEEN_EXIST("30900", "商品名称已存在"),
    WARE_TYPE_NAME_HAS_BEEN_EXIST("30901", "分类名称已存在"),
    WARE_TYPE_ICON_NOT_NULL("30902", "一级分类图标不能为空"),
    GROUP_DONT_DELETE("30903", "该分类下尚有商品存在"),
    GOODS_STATUS_ERROR("30904", "状态有误"),
    GOODS_ON_SHELF_SUCCESS("30905", "商品上架成功"),
    GOODS_DOWN_SHELF_SUCCESS("30906", "商品下架成功"),
    GOODS_SKU_IS_NOT_NULL("30907", "商品规格不能为空"),
    GOODS_PIC_IS_NOT_NULL("30908", "主图不能为空"),
    GOODS_DESC_IS_NOT_NULL("30910", "商品描述不能为空"),
    GOODS_GROUP_IS_NOT_NULL("30911", "商品类型不能为空"),
    GROUP_DONT_DELETE_BY_CHILD("30912", "该分类下尚有子分类存在"),
    GOODS_NOT_EXIST_OR_ALREADY_DOWN_SHELF("30913", "商品不存在或已下架"),
    GOODS_NAME_IS_NOT_NULL("30914", "商品名称不能为空或名字长度不能大于60"),
    GOODS_DELETE_FAIL("30915", "批量删除商品失败,商品已被其他商品绑定"),
    BRAND_DELETE_FAIL("30916", "删除失败，产品管理中有产品绑定该品牌名称"),
    //返祖
    RETURN_SHARE_ORDER_ERROR("40000", "设备返祖订单相关信息找不到，请重新输入订单号"),
    RETURN_SHARE_ORDER_NOT_FINISH_ERROR("40001", "此设备的订单未完成，请添加其他设备"),
    RETURN_SHARE_ORDER_HAS_BEEN_ADD_ERROR("40002", "此订单的设备已经被添加过，不能重复添加"),

    //宣传中心
    EXIST_SAME_NAME_OF_MODULE_ERROR("40500", "所属产品中不能有相同名字的模块"),
    EXIST_SAME_NAME_OF_BANNER_ERROR("40501", "名称重复，请重新输入"),
    EXIST_SAME_CODE_OF_MODULE_ERROR("40502", "moduleCode已重复，请输入其他moduleCode"),
    HAS_BEEN_USE_ERROR("40503", "此标签有用户在使用，不能删除！"),

    FILE_PARSE_ERROR("40600", "上传文件无数据或内容识别失败，请重新上传"),
    HAS_BEEN_APPLY_ERROR("40601", "已提交申请！将有客服人员与你联系"),
    PRICE_TO_HIGH_ERROR("40602", "标价请确认在0-10000000万元内"),
    EXIST_SAME_NAME_ERROR("40603", "快讯名称重复，请重新上传"),
    TENDER_FORMAT_ERROR("40604", "招标序号或内容不能为空，请补全后上传"),
    TENDER_CONTENT_TOO_LONG_ERROR("40605", "存在招标内容字符过长"),

    GOODS_CATEGORY_NAME_EXIST_ERROR("40605", "名称重复，请重新输入!"),
    CONTRACT_STATUS_MISTAKEN("40607", "当前合同状态不可进行编辑!"),
    CONTRACT_STATUS_CANNOT_BE_DELETED("40607", "当前合同状态不可进行删除!"),
    CONTRACT_NOT_EXIST("40608", "合同不存在或已删除!"),
    CONTRACT_STATUS_DOES_NOT_ALLOW_FILE("40609", "该状态合同不允许归档!"),
    SEAL_INFO_NOT_EXIST("40610", "请前往印章管理上传印章或设置默认印章!"),
    AGENCY_NO_FLYER("40611", "机构下暂无飞手，快去招募吧~"),
    NO_FLYER_WORK("40612", "现在没有飞手上班哦~"),
    TEMPORARY_NOT_SUPPORT_TRANSFER_ORDER("40613", "个人订单暂不支持转单操作~"),
    ELECTRONIC_SIGNATURE_NOT_REAL_NAME_AUTHENTICATION("40614", "请完成电子签约实名认证后再进行操作"),
    DIRECTORY_DOES_NOT_EXIST("40615", "目录不存在或已删除"),
    DEFAULT_DIRECTORY_CANNOT_BE_DEL("40616", "默认目录不可删除"),
    THERE_ARE_CATEGORIES_IN_THE_DIRECTORY("40167", "该目录下有分类存在不可删除"),
    DIRECTORY_NAME_HAS_BEEN_EXIST("40168", "目录名称已存在"),
    FAILED_TO_ADD_DATA("40169", "数据新增失败，请稍后重试"),
    FAILED_TO_EDIT_DATA("40170", "数据修改失败，请稍后重试"),
    SKU_DOES_NOT_EXIST_OR_HAS_BEEN_DELETED("40171", "sku不存在或已删除，请刷新后重试！"),
    SPEC_DOES_NOT_EXIST_OR_HAS_BEEN_DELETED("40172", "规格不存在或已删除，请刷新后重试！"),
    SKU_ALREADY_EXIST_IN_THIS_INDUSTRY("40173", "该所属行业下已经存在sku，请检查后重试！"),
    SPEC_EXIST_UNDER_THE_SKU("40174", "该sku下有规格存在，无法删除！"),
    SPEC_NOT_CONFIG_PRICE("40175", "存在规格没有配置价格，请联系客服获取报价！"),
    SHOP_CAR_SIZE_MORE_2("40176", "行业购物车下单数量仅限一个"),
    CONTRACT_TEMPLATE_NOT_EXIST_OR_DELETED("40177", "合同模板不存在或已删除！"),
    SCORE_ERROR("40177", "您输入的积分数量有误，请重新输入！"),
    PLEASE_FILL_IN_THE_CONTRACT_TEMPLATE_FIRST("40178", "请先填充合同模板！"),

    SCORE_NOT_GIVE_MYSELF("40179", "积分不能转赠给本人,请重新操作"),

    ALREADY_FINISH_ENT_AUTH_ERROR("2000", "助力已完成！"),
    SYSTEM_ERROR("2001", "系统错误,请稍后重试"),
    RULE_ERROR("2002", "当前兑换比例已失效，请刷新后重试"),
    COUNT_LIMIT_ERROR("2003", "参与次数已达上线"),
    ALREADY_ENT_AUTH_ERROR("2004", "助力失败，您已完成企业认证！"),
    ALREADY_REAL_NAME_AUTH_ERROR("2005", "助力失败，您已完成实名认证！"),
    PARTICIPATE_BUT_NOT_AUTH_ERROR("2006", "待完成授权或认证"),
    ALREADY_HELP_ERROR("2007", "已助力"),
    ALREADY_STOP_ERROR("2008", "活动已下线"),
    HELP_FAIL_ERROR("2009", "不能给自己助力哦！"),
    ALREADY_BINDING_ERROR("2010", "优惠券已被绑定"),
    ALREADY_DIVIDE_ERROR("2011", "订单已分成"),
    DIVIDE_OBJ_NOT_EXIST("2012", "先点击确认添加分成对象"),

    // 新闻行业
    INDUSTRY_NEWS_TITLE_EXISTS("40200", "文章标题存在"),

    // 论坛
    DYNAMIC_SENSITIVE_INFO("50100", "发布信息涉及敏感信息！"),
    THE_ORGANIZATION_NAME_ALREADY_EXISTS("60001", "机构名称已存在"),
    YOU_CANNOT_MODIFY_REQUIREMENTS_PUBLISHED_BY_OTHERS("60003", "不能修改他(她)人发布的需求"),
    YOU_CANNOT_DELETE_REQUIREMENTS_POSTED_BY_OTHERS("60004", "不能删除他(她)人发布的需求"),
    THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED("60005", "第三方接口在更新请联系开发人员"),
    THREE_FIELDS_CAN_BE_REPEATED("60002", "机型、等级、类型存在重复"),
    FALL_OUTSIDE_OF("60003", "不在打卡范围之内"),
    OVER_THE_TOTAL("60004", "总金额大于云享金剩余的金额,发布失败"),
    SALARY_PAYMENT_FAILURE("60005", "总金额大于佣金剩余的金额,发布失败"),
    CASH_SALARY_PAYMENT_FAILURE("60006", "总金额大于佣金剩余的金额加上云享金剩余的金额,发布失败"),
    PLEASE_SELECT_PAYMENT("60007", "请选择支付方式,发布失败"),
    CASH_IS_ENOUGH("60008", "云享金额已足够,无需微信支付"),
    SALARY_IS_ENOUGH("60009", "佣金剩余金额已足够,无需微信支付"),
    YOU_CANNOT_CANCEL_THE_ORDER_AT_THIS_TIME("70000", "当前不能取消订单流程"),
    PAYMENT_SUCCESS("70001", "你支付的保证金全额扣除成功"),
    THE_AMOUNT_OF_THE_MISSION_WILL_BE_RETURNED("70002", "任务佣金原路退回成功"),
    REFUND_PERCENTAGE("7003", "任务佣金百分之七十原路退回成功"),

    ORDER_AMOUNT_ERROR("8001", "订单金额不足");

    /**
     * 错误码
     *
     * @return
     */
    String resultCode;

    /**
     * 错误描述
     *
     * @return
     */
    String resultMsg;

    ResultEnum(String resultCode, String resultMsg) {
        this.resultCode = resultCode;
        this.resultMsg = resultMsg;
    }

    @Override
    public String getResultCode() {
        return resultCode;
    }

    @Override
    public String getResultMsg() {
        return resultMsg;
    }
}
