package com.mmc.csf.release.entity.requirements;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/8/22 13:54
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class RequirementsAmountDO implements Serializable {


    private static final long serialVersionUID = -1811974173256250060L;

    private Integer id;

    @ApiModelProperty(value = "发布需求id", example = "1")
    private Integer requirementsInfoId;

    @ApiModelProperty(value = "发布者订单金额", example = "1")
    private BigDecimal orderAmount;

    @ApiModelProperty(value = "发布者支付总金额", example = "1")
    private BigDecimal totalAmount;

    @ApiModelProperty(value = "级别金额", example = "1")
    private BigDecimal orderLevelAmount;


    @ApiModelProperty(value = "订单级别 REGULAR_ORDER,RUSH_ORDER,TOP_ORDER", example = "订单级别 REGULAR_ORDER,RUSH_ORDER,TOP_ORDER")
    private String orderLevel;

    @ApiModelProperty(value = "发布者支付微信金额", example = "1")
    private BigDecimal weChat;

    @ApiModelProperty(value = "发布者支付佣金金额", example = "1")
    private BigDecimal salaryAmount;

    @ApiModelProperty(value = "发布者微信支付订单", example = "1")
    private String wechatPayOrderNumber;

    @ApiModelProperty(value = "修改任务后的佣金", example = "1")
    private BigDecimal updateOrderAmount;

    @ApiModelProperty(value = "原因", example = "原因")
    private String reason;

    @ApiModelProperty(value = "原因", example = "原因")
    private String url;
    @ApiModelProperty(value = "后台获取token里面的用户id", hidden = true)
    private Integer userAccountId;
    @ApiModelProperty(value = "云享金", example = "10")
    private BigDecimal cashAmount;

    public RequirementsAmountDO(ServiceRequirementsDO requirementsInfoDO) {
        this.requirementsInfoId = requirementsInfoDO.getId();
        this.orderAmount = requirementsInfoDO.getOrderAmount();
        this.totalAmount = requirementsInfoDO.getTotalAmount();
        this.orderLevelAmount = requirementsInfoDO.getOrderLevelAmount();
        this.orderLevel = requirementsInfoDO.getOrderLevel();
        this.weChat = requirementsInfoDO.getWeChat();
        this.salaryAmount = requirementsInfoDO.getSalaryAmount();
        this.wechatPayOrderNumber = requirementsInfoDO.getWechatPayOrderNumber();
        this.userAccountId = requirementsInfoDO.getUserAccountId();
        this.cashAmount = requirementsInfoDO.getCashAmount();
    }

}
