package com.mmc.csf.infomation.vo;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/8/19 10:24
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WalletFlowVO {

    @ApiModelProperty(value = "用户ID")
    private Integer userAccountId;

    @ApiModelProperty(value = "支付方式 200结算(完成) 300冻结 100订单取消")
    private Integer modeOfPayment;

    @ApiModelProperty(value = "云享金")
    private BigDecimal cashAmount;

    @ApiModelProperty(value = "佣金")
    private BigDecimal salaryAmount;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private String timeOfPayment;

    @ApiModelProperty(value = "操作者用户ID")
    private Integer operateUserAccountId;

    @ApiModelProperty(value = "微信金额")
    private BigDecimal weChat;


}
