package com.mmc.csf.infomation.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/8/19 22:26
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class GrabTheOrderVO {

    private static final long serialVersionUID = -447951390213113317L;
    @ApiModelProperty(value = "id")
    @NotNull(message = "id不能为空", groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "云享金", example = "10", hidden = true)
    private BigDecimal cashAmount;

    @ApiModelProperty(value = "佣金", example = "10", hidden = true)
    private BigDecimal salaryAmount;

    @ApiModelProperty(value = "微信支付订单编号", example = "R202308191657303116170")
    private String wechatPayOrderNumber;

    @ApiModelProperty(value = "微信金额", example = "10", hidden = true)
    private BigDecimal weChat;

    @ApiModelProperty(value = "发布者任务编号", example = "R202308192201279509820")
    private String publisherNumber;

    @JsonIgnore
    private Integer userAccountId;

    @ApiModelProperty(value = "支付方式，云享金：1，佣金：2，微信支付：3", example = "1,2,3")
    private String paymentType;


}
