package com.mmc.csf.release.entity.curriculum;

import com.mmc.csf.release.model.group.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author Admin
 * @date 2023/12/07
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CurriculumOrderQO implements Serializable {
    private final static long serialVersionUID = 1L;
    @ApiModelProperty(value = "页码", required = true,example = "1")
    @NotNull(message = "页码不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;
    @ApiModelProperty(value = "每页显示数", required = true,example = "10")
    @NotNull(message = "每页显示数不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    @ApiModelProperty(value = "订单编号")
    private String orderNo;

    @ApiModelProperty
    private Integer curriculumInfoId;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
