package com.mmc.csf.release.entity.curriculum;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 
 * @author Admin
 * @TableName curriculum_order
 */
@Data
public class CurriculumOrderDO implements Serializable {
    /**
     * 
     */
    @ApiModelProperty(value = "课程订单id")
    private Integer id;

    /**
     * 订单编号
     */
    @ApiModelProperty(value = "课程订单编号")
    private String orderNo;

    /**
     * 下单用户id
     */
    @ApiModelProperty(value = "购买用户的id")
    private Integer userAccountId;


    /**
     * 订单总金额
     */
    @ApiModelProperty(value = "订单总金额")
    private BigDecimal orderTotalAmount;

    /**
     * 抵扣佣金金额
     */
    @ApiModelProperty(value = "抵扣佣金金额")
    private BigDecimal salaryAmount;

    /**
     * 抵扣云享金金额
     */
    @ApiModelProperty(value = "抵扣云享金金额")
    private BigDecimal cashAmount;

    /**
     * 微信支付金额
     */
    @ApiModelProperty(value = "微信支付金额")
    private BigDecimal weChat;

    /**
     * 发布者微信支付订单
     */
    @ApiModelProperty(value = "发布者微信支付订单")
    private String wechatPayOrderNumber;

    /**
     * 课程ID
     */
    @ApiModelProperty(value = "课程ID")
    private Integer curriculumInfoId;
    /**
     * 所需积分
     */
    @ApiModelProperty(value = "所需积分")
    private int jifenConsume;


    private static final long serialVersionUID = 1L;
}