package com.mmc.csf.release.entity.licence;

import com.mmc.csf.licence.vo.LicenseTrainingProgramsVO;
import com.mmc.csf.release.model.group.Create;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/7/14 11:20
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LicenseTrainingProgramsDO {


    @ApiModelProperty(value = "培训id", example = "1")
    @NotNull(message = "培训id不能为空", groups = Update.class)
    private Integer id;

    @ApiModelProperty(value = "培训等级id", example = "1", required = true)
    @NotNull(message = "培训等级id不能为空", groups = {Create.class, Update.class})
    private Integer gradeId;

    @ApiModelProperty(value = "培训机型id", example = "1", required = true)
    @NotNull(message = "培训机型id不能为空", groups = {Create.class, Update.class})
    private Integer modelsId;

    @ApiModelProperty(value = "培训类型id", example = "1", required = true)
    @NotNull(message = "培训类型id不能为空", groups = {Create.class, Update.class})
    private Integer typeId;

    @ApiModelProperty(value = "培训价格", example = "1000", required = true)
    @NotNull(message = "培训价格不能为空", groups = {Create.class, Update.class})
    private BigDecimal price;

    @ApiModelProperty(value = "培训地点不能为空", example = "1", required = true)
    @NotBlank(message = "培训地点不能为空", groups = {Create.class, Update.class})
    private String place;

    @ApiModelProperty(value = "培训主图不能为空", example = "1", required = true)
    @NotBlank(message = "培训主图不能为空", groups = {Create.class, Update.class})
    private String mainImage;


    /**
     * VO类转换
     */
    public LicenseTrainingProgramsDO(LicenseTrainingProgramsVO programsVO) {
        this.id = programsVO.getId();
        this.mainImage = programsVO.getMainImage();
        this.gradeId = programsVO.getGradeId();
        this.modelsId = programsVO.getModelsId();
        this.typeId = programsVO.getTypeId();
        this.price = programsVO.getPrice();
        this.place = programsVO.getPlace();
    }


}
