package com.mmc.csf.release.service.impl;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.dao.FlyerTrainingDao;
import com.mmc.csf.release.entity.CurriculumInfoDO;
import com.mmc.csf.release.entity.FlightSkillsDO;
import com.mmc.csf.release.entity.PilotRegistrationDO;
import com.mmc.csf.release.flyer.qo.CurriculumQo;
import com.mmc.csf.release.flyer.vo.CurriculumInfoVO;
import com.mmc.csf.release.flyer.vo.DronePilotLicenseVO;
import com.mmc.csf.release.flyer.vo.RegistrationVO;
import com.mmc.csf.release.service.FlyerTrainingService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author LW
 * @date 2023/5/15 10:11
 * 概要：
 */
@Service
public class FlyerTrainingServiceImpl implements FlyerTrainingService {

    @Resource
    private FlyerTrainingDao flyerTrainingDao;

    @Override
    public ResultBody pilotRegistration(RegistrationVO registrationVO) {
        PilotRegistrationDO pilotRegistrationDO = new PilotRegistrationDO(registrationVO,registrationVO.getId());
        if (CollectionUtils.isNotEmpty(registrationVO.getIndustryAppAuth())) {
            // 将行业应用认证的id用逗号拼接
            String industryAppAuth = registrationVO.getIndustryAppAuth().stream().map(Object::toString).collect(Collectors.joining(","));
            pilotRegistrationDO.setIndustryAppAuth(industryAppAuth);
        }
        flyerTrainingDao.insertPilotRegistrationInfo(pilotRegistrationDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody getDronePilotLicense() {
        List<DronePilotLicenseVO> allLicenses = flyerTrainingDao.selectAllLicenses();
        List<DronePilotLicenseVO> topLevelLicenses = new ArrayList<>();
        Map<Integer, DronePilotLicenseVO> licenseMap = new HashMap<>();

        // 将每个数据模型对象添加到Map中，以便在递归过程中查找它们的父母
        for (DronePilotLicenseVO license : allLicenses) {
            license.setChildLicenses(new ArrayList<>());
            licenseMap.put(license.getId(), license);
        }

        // 构建树结构
        for (DronePilotLicenseVO license : allLicenses) {
            if (license.getParentId() == 0) {
                topLevelLicenses.add(license);
            } else {
                DronePilotLicenseVO parent = licenseMap.get(license.getParentId());
                parent.getChildLicenses().add(license);
            }
        }
        return ResultBody.success(topLevelLicenses);
    }

    @Override
    public ResultBody getIndustryFlightSkills() {
        List<FlightSkillsDO> flightSkillsList = flyerTrainingDao.listIndustryFlightSkills();
        return ResultBody.success(flightSkillsList.stream()
                .map(FlightSkillsDO::buildFlightSkillsVO).collect(Collectors.toList()));
    }

    @Override
    public PageResult queryCurriculumInfoList(CurriculumQo curriculumQo) {
        Integer SZ = 440300;
        if (curriculumQo.getRegionId() != null && !curriculumQo.getRegionId().equals(SZ)) {
            return PageResult.buildPage(curriculumQo.getPageNo(), curriculumQo.getPageSize(), 0);
        }
        int count = flyerTrainingDao.countCurriculumInfoList(curriculumQo);
        if (count == 0) {
            return PageResult.buildPage(curriculumQo.getPageNo(), curriculumQo.getPageSize(), count);
        }
        Integer pageNo = curriculumQo.getPageNo();
        curriculumQo.buildCurrentPage();
        List<CurriculumInfoDO> curriculumList = flyerTrainingDao.listPageCurriculumInfo(curriculumQo);
        List<CurriculumInfoVO> list = curriculumList.stream().map(CurriculumInfoDO::buildCurriculumInfoVO).collect(Collectors.toList());
        return PageResult.buildPage(pageNo, curriculumQo.getPageSize(), count, list);
    }


    @Override
    public ResultBody licenseOrSkillQueryCurriculum(Integer type) {
        List<CurriculumInfoDO> curriculumInfoList;
        if (type == 0) {
            // 表示查询考证的
            curriculumInfoList = flyerTrainingDao.selectLicensesCurriculum();
        } else {
            curriculumInfoList = flyerTrainingDao.selectSkillCurriculum(type);
        }
        return ResultBody.success(curriculumInfoList == null ? null : curriculumInfoList.stream()
                .map(CurriculumInfoDO::buildCurriculumInfoVO).collect(Collectors.toList()));
    }
}
