package com.mmc.csf.release.entity.requirements;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.mmc.csf.config.IsNullConvertZero;
import com.mmc.csf.infomation.vo.OrderLevelEnum;
import com.mmc.csf.release.model.group.Insert;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

/**
 * @author 张培
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ServiceRequirementsSonDO {
    @ApiModelProperty(value = "id")
    @NotNull(message = "id不能为空", groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "id")
    @NotBlank(message = "服务类型id不能为空", groups = {Insert.class, Update.class})
    private Integer serviceId;

    @ApiModelProperty(value = "飞行日期——任务开始时间", example = "2023-07-25", required = true)
    @NotNull(message = "任务开始时间不能为空", groups = {Insert.class, Update.class})
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date taskStartTime;

    @ApiModelProperty(value = "飞行日期——任务结束时间", example = "2023-07-26", required = true)
    @NotNull(message = "任务开始时间不能为空", groups = {Insert.class, Update.class})
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date taskEndTime;

    @ApiModelProperty(value = "飞行位置——任务地址", example = "广东省深圳市", required = true)
    @NotBlank(message = "任务地址不能为空", groups = {Insert.class, Update.class})
    private String taskAddress;


    @ApiModelProperty(value = "飞行位置——任务经度", example = "23.344324")
    private Double longitude;

    @ApiModelProperty(value = "飞行位置——任务纬度", example = "44.344324")
    private Double latitude;

    @ApiModelProperty(value = "省份编码", required = false)
    //@NotNull(message = "省份编码不能为空", groups = {Insert.class})
    private Integer provinceCode;
    @ApiModelProperty(value = "市编码", required = false)
    private Integer cityCode;
    @ApiModelProperty(value = "区编码", required = false)
    private Integer districtCode;

    @ApiModelProperty(value = "需求描述", example = "描述一下", required = true)
    @NotNull(message = "需求描述不能为空", groups = {Insert.class})
    @Length(max = 300, message = "字符过长")
    private String requireDescription;

    @ApiModelProperty(value = "订单金额", example = "订单金额", required = true)
    @NotNull(message = "订单金额", groups = {Insert.class})
    @IsNullConvertZero
    private BigDecimal orderAmount;

    @ApiModelProperty(value = "飞手保险", example = "飞手保险", required = true)
    @NotNull(message = "飞手保险", groups = {Insert.class})
    private String insurance;

    @ApiModelProperty(value = "订单级别", example = "订单级别", required = true)
    @NotNull(message = "订单级别", groups = {Insert.class})
    private OrderLevelEnum orderLevelEnum;

    @ApiModelProperty(value = "后台获取token里面的用户id", hidden = true)
    private Integer userAccountId;

    @ApiModelProperty(value = "发布者姓名", example = "张三")
    private String publishName;

    @ApiModelProperty(value = "发布者电话", example = "1892994543", required = true)
    @NotNull(message = "发布者电话不能为空", groups = {Insert.class})
    private String publishPhone;

    @ApiModelProperty(value = "发布者订单编号")
    private String publisherNumber;

    @ApiModelProperty(value = "0普通 100急单 300置顶")
    @IsNullConvertZero
    private BigDecimal orderLevelAmount;

    @ApiModelProperty(value = "订单级别 REGULAR_ORDER,RUSH_ORDER,TOP_ORDER")
    private String orderLevel;

    @ApiModelProperty(value = "总金额", example = "100", required = true)
    @NotNull(message = "总金额", groups = {Insert.class})
    @IsNullConvertZero
    private BigDecimal totalAmount;


    @ApiModelProperty(value = "云享金", example = "10")
    @IsNullConvertZero
    private BigDecimal cashAmount;

    @ApiModelProperty(value = "佣金", example = "10")
    @IsNullConvertZero
    private BigDecimal salaryAmount;

    @ApiModelProperty(value = "微信金额", example = "10")
    @IsNullConvertZero
    private BigDecimal weChat;

    @ApiModelProperty(value = "微信支付订单编号", example = "R202308191657303116170")
    private String wechatPayOrderNumber;

    private Integer repertory;


    @ApiModelProperty(value = "支付方式，云享金：1，佣金：2，微信支付：3", example = "1,2,3")
    private String paymentType;
    @ApiModelProperty(value = "地区编码")
    private String adcode;
    @IsNullConvertZero
    @ApiModelProperty(value = "置顶/加急 佣金支付多少", example = "100")
    private BigDecimal levelSalaryAmount;
    @ApiModelProperty(value = "置顶/加急 微信支付多少", example = "100")
    @IsNullConvertZero
    private BigDecimal levelWeChatAmount;
    @ApiModelProperty(value = "置顶/加急 云享金支付多少", example = "100")
    @IsNullConvertZero
    private BigDecimal levelCashAmount;
    @ApiModelProperty(value = "openid")
    private String openid;

    @ApiModelProperty(value = "服务名称")
    private String serviceName;

    @ApiModelProperty(value = "订单总共所需多少人")
    private Integer requireNum;

    @ApiModelProperty(value = "上级订单id")
    private Integer fatherRequireId;

    public ServiceRequirementsSonDO(ServiceRequirementsDO serviceRequirementsDO) {
        BigDecimal decimalSum = new BigDecimal(serviceRequirementsDO.getRequireNum());
        this.serviceId = serviceRequirementsDO.getServiceId();
        this.taskStartTime = serviceRequirementsDO.getTaskStartTime();
        this.taskEndTime = serviceRequirementsDO.getTaskEndTime();
        this.taskAddress = serviceRequirementsDO.getTaskAddress();
        this.longitude = serviceRequirementsDO.getLongitude();
        this.latitude = serviceRequirementsDO.getLatitude();
        this.provinceCode = serviceRequirementsDO.getProvinceCode();
        this.cityCode = serviceRequirementsDO.getCityCode();
        this.districtCode = serviceRequirementsDO.getDistrictCode();
        this.requireDescription = serviceRequirementsDO.getRequireDescription();
        this.orderAmount = serviceRequirementsDO.getOrderAmount().divide(decimalSum,2, RoundingMode.HALF_UP);
        this.insurance = serviceRequirementsDO.getInsurance();
        this.orderLevelEnum = serviceRequirementsDO.getOrderLevelEnum();
        this.userAccountId = serviceRequirementsDO.getUserAccountId();
        this.publishName = serviceRequirementsDO.getPublishName();
        this.publishPhone = serviceRequirementsDO.getPublishPhone();
        this.publisherNumber = serviceRequirementsDO.getPublisherNumber();
        this.orderLevelAmount = serviceRequirementsDO.getOrderLevelAmount();
        this.orderLevel = serviceRequirementsDO.getOrderLevel();
        this.totalAmount = serviceRequirementsDO.getTotalAmount().divide(decimalSum,2,RoundingMode.HALF_UP);
        this.cashAmount = serviceRequirementsDO.getCashAmount().divide(decimalSum,2,RoundingMode.HALF_UP);
        this.salaryAmount = serviceRequirementsDO.getSalaryAmount().divide(decimalSum,2,RoundingMode.HALF_UP);
        this.weChat = serviceRequirementsDO.getWeChat().divide(decimalSum,2,RoundingMode.HALF_UP);
        this.wechatPayOrderNumber = serviceRequirementsDO.getWechatPayOrderNumber();
        this.repertory = 1;
        this.paymentType = serviceRequirementsDO.getPaymentType();
        this.adcode = serviceRequirementsDO.getAdcode();
        this.levelSalaryAmount = serviceRequirementsDO.getLevelSalaryAmount().divide(decimalSum,2,RoundingMode.HALF_UP);
        this.levelWeChatAmount = serviceRequirementsDO.getLevelWeChatAmount().divide(decimalSum,2,RoundingMode.HALF_UP);
        this.levelCashAmount = serviceRequirementsDO.getLevelCashAmount().divide(decimalSum,2,RoundingMode.HALF_UP);
        this.openid = serviceRequirementsDO.getOpenid();
        this.serviceName = serviceRequirementsDO.getServiceName();
        this.requireNum = 1;
        this.fatherRequireId = serviceRequirementsDO.getId();
    }
}
