package com.mmc.csf.config;

import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Objects;

/**
 * @Author small
 * @Date 2023/8/23 14:16
 * @Version 1.0
 */
@Slf4j
public class IsNullConvertZeroUtil {

    public static Object checkIsNull(Object obj) {
        try {
            Class<?> clazz = obj.getClass();
            //获得私有的成员属性
            Field[] fields = clazz.getDeclaredFields();
            if (Objects.nonNull(fields) && fields.length > 0) {
                for (Field field : fields) {
                    field.setAccessible(true);
                    //判断IsNullConvertZero注解是否存在
                    if (field.isAnnotationPresent(IsNullConvertZero.class)) {
                        if (Objects.isNull(field.get(obj))) {
                            field.set(obj, BigDecimal.ZERO);
                        }
                    }
                }
            }
        } catch (Exception e) {
            log.error("IsNullConvertZeroUtil出现异常：{}", e);
        }
        return obj;
    }
}

