package com.mmc.csf.release.entity.requirements;

import com.alibaba.fastjson.annotation.JSONField;
import com.mmc.csf.infomation.dto.ServiceFulfilATaskDTO;
import com.mmc.csf.infomation.vo.ServiceFulfilATaskVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @Author small
 * @Date 2023/8/18 20:40
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class ServiceFulfilATaskDO {
    private Integer id;

    @ApiModelProperty(value = "完成任务描述", example = "完成任务描述一下")
    private String taskDescribe;

    @ApiModelProperty(value = "完成任务图片", example = "http://")
    private String taskUrl;

    @ApiModelProperty(value = "需求id", example = "83")
    private Integer requirementsInfoId;

    @ApiModelProperty(value = "完成任务的用户", example = "1", hidden = true)
    private Integer userAccountId;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;


    public ServiceFulfilATaskDO(ServiceFulfilATaskVO serviceFulfilATaskVO) {
        this.taskDescribe = serviceFulfilATaskVO.getTaskDescribe();
        this.taskUrl = serviceFulfilATaskVO.getTaskUrl();
        this.requirementsInfoId = serviceFulfilATaskVO.getRequirementsInfoId();
        this.userAccountId = serviceFulfilATaskVO.getUserAccountId();
    }


    public ServiceFulfilATaskDTO buildServiceFulfilATaskDTO() {
        return ServiceFulfilATaskDTO.builder()
                .id(this.id)
                .taskDescribe(this.taskDescribe)
                .taskUrl(this.taskUrl)
                .requirementsInfoId(this.requirementsInfoId)
                .userAccountId(this.userAccountId)
                .createTime(this.createTime)
                .updateTime(this.updateTime)
                .build();
    }
}
