package com.mmc.csf.release.controller;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.entity.forum.*;
import com.mmc.csf.release.forum.vo.DynamicVO;
import com.mmc.csf.release.gambit.dto.ForumDynamicGambitDTO;
import com.mmc.csf.release.gambit.dto.ForumGambitDTO;
import com.mmc.csf.release.gambit.qo.*;
import com.mmc.csf.release.gambit.vo.ForumGambitVO;
import com.mmc.csf.release.service.gambit.GambitService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author small
 * @Date 2023/9/13 15:29
 * @Version 1.0
 */
@Api(tags = {"web-小程序-论坛社区-模块发布话题"})
@RestController
@RequestMapping("/gambit")
public class GambitController extends BaseController{


    @Autowired
    private GambitService gambitService;


    @ApiOperation(value = "添加话题")
    @PostMapping("/insertGambit")
    public ResultBody insertGambit(@RequestBody ForumGambitVO forumGambitVO, HttpServletRequest request){
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        forumGambitVO.setUserAccountId(userAccountId);
      return   gambitService.insertGambit(forumGambitVO);
    }

    @ApiOperation(value = "编辑话题")
    @PostMapping("/updateGambit")
    public ResultBody updateGambit(@RequestBody ForumGambitVO forumGambitVO, HttpServletRequest request){
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        forumGambitVO.setUserAccountId(userAccountId);
      return  gambitService.updateGambit(forumGambitVO);
    }

    @ApiOperation(value = "删除话题")
    @GetMapping("/deleteGambit")
    public ResultBody deleteGambit(@RequestParam(value = "id") Integer id ){
        return gambitService.deleteGambit(id);
    }


    @ApiOperation(value = "后台管理话题列表")
    @PostMapping("/listGambit")
    public ResultBody<ForumGambitDTO> listGambit(@RequestBody ForumGambitQO forumGambitQO){
        return ResultBody.success(gambitService.listGambit(forumGambitQO));
    }


    @ApiOperation(value = "关注")
    @GetMapping("/attention")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "status",value = "关注状态 true",dataType = "Boolean",required = true),
            @ApiImplicitParam(name = "userAccountId",value = "被关注的用户",dataType = "Integer",required = true)
    })
    public ResultBody attention(@RequestParam(value = "status") Boolean status,
                                @RequestParam(value = "userAccountId")Integer userAccountId,
                                HttpServletRequest request){
        Integer attentionUserAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return gambitService.attention(status,userAccountId,attentionUserAccountId);
    }


    @ApiOperation(value = "转发数")
    @GetMapping("/transPond")
    public ResultBody transPond(@RequestParam(value = "dynamicId")Integer dynamicId,HttpServletRequest request){
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return gambitService.transPond(dynamicId,userAccountId);
    }


  /*  @ApiOperation(value = "评论下面——点赞或取消点赞")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/commentLikes")
    public ResultBody commentLikes(HttpServletRequest request, @ApiParam(value = "dynamicId") @RequestParam Integer dynamicId) {
        return gambitService.commentLikes(this.getUserLoginInfoFromRedis(request).getUserAccountId(), dynamicId);
    }*/


    @ApiOperation(value = "小程序——自己删除自己的贴子")
    @GetMapping("/appRemove")
    public ResultBody appRemove(HttpServletRequest request, @ApiParam(value = "dynamicId") @RequestParam Integer dynamicId){
        return gambitService.appRemove(this.getUserLoginInfoFromRedis(request).getUserAccountId(),dynamicId);

    }


    @ApiOperation(value = "小程序话题下面的动态列表")
    @PostMapping("/appGambitLists")
    public ResultBody<ForumDynamicGambitDO> appGambitList(HttpServletRequest request, @RequestBody TopicDynamicsQO topicDynamicsQO){
       return ResultBody.success(gambitService.appGambitList(topicDynamicsQO));
    }


    @ApiOperation(value = "动态对应的所有评论")
    @PostMapping("/allCommentList")
    public ResultBody<ForumReviewDO> allCommentList(HttpServletRequest request, @RequestBody  AllReviewQO allReviewQO){
        String token = request.getHeader("token");
        if (token!=null){
            Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
            Integer userAccountId1 = allReviewQO.getUserAccountId();
            if (userAccountId1==null){
                allReviewQO.setUserAccountId(userAccountId);
            }
        }
        allReviewQO.setUserAccountId(allReviewQO.getUserAccountId());
        return ResultBody.success(gambitService.allCommentList(allReviewQO));
    }

    @ApiOperation(value = "动态下某一条评论下面所有回复")
    @PostMapping("/replyList")
    public ResultBody<ForumReviewDO> replyList(HttpServletRequest request, @RequestBody AppReplyQO replyQO){
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        replyQO.setUserAccountId(userAccountId);
        return ResultBody.success(gambitService.replyList(replyQO));
    }

    @ApiOperation(value = "用户发的动态")
    @PostMapping("/userDynamicList")
    public ResultBody<ForumDynamicGambitDO> userDynamicList(HttpServletRequest request, @RequestBody UserTopicDynamicsQO userTopicDynamicsQO){
        return ResultBody.success(gambitService.userDynamicList(userTopicDynamicsQO));
    }

    @ApiOperation(value = "赞过")
    @PostMapping("/liked")
    public ResultBody<DynamicVO> liked(HttpServletRequest request, @RequestBody UserTopicDynamicsQO userTopicDynamicsQO){
        return ResultBody.success(gambitService.liked(userTopicDynamicsQO,request));
    }

    @ApiOperation(value = "我的关注")
    @PostMapping("/myInterestList")
    public ResultBody<MyAttentionDO> myInterestList(HttpServletRequest request, @RequestBody UserTopicDynamicsQO userTopicDynamicsQO){
        Integer userId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        userTopicDynamicsQO.setUserId(userId);
        return ResultBody.success(gambitService.myInterestList(userTopicDynamicsQO));
    }

    @ApiOperation(value = "我的粉丝")
    @PostMapping("/myFansList")
    public ResultBody<MyFansDO> myFansList(HttpServletRequest request, @RequestBody UserTopicDynamicsQO userTopicDynamicsQO){
        Integer userId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        userTopicDynamicsQO.setUserId(userId);
        return ResultBody.success(gambitService.myFansList(userTopicDynamicsQO));
    }


    @ApiOperation(value = "单个用户信息")
    @GetMapping("/userMessage")
    public ResultBody<ForumCountDO> userMessage(HttpServletRequest request, @ApiParam(value = "userAccountId") @RequestParam Integer userAccountId){
        Integer userId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return gambitService.userMessage(userAccountId,userId,request);
    }









}
