package com.mmc.csf.release.service.impl;

import com.mmc.csf.release.dao.FlyerTrainingDao;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.entity.FlightSkillsDO;
import com.mmc.csf.release.entity.PilotRegistrationDO;
import com.mmc.csf.release.service.FlyerTrainingService;
import com.mmc.csf.release.vo.DronePilotLicenseVO;
import com.mmc.csf.release.vo.RegistrationVO;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author LW
 * @date 2023/5/15 10:11
 * 概要：
 */
@Service
public class FlyerTrainingServiceImpl implements FlyerTrainingService {

    @Resource
    private FlyerTrainingDao flyerTrainingDao;

    @Override
    public ResultBody pilotRegistration(RegistrationVO registrationVO, Integer id) {
        PilotRegistrationDO pilotRegistrationDO = new PilotRegistrationDO(registrationVO, id);
        if (CollectionUtils.isNotEmpty(registrationVO.getIndustryAppAuth())) {
            // 将行业应用认证的id用逗号拼接
            String industryAppAuth = registrationVO.getIndustryAppAuth().stream().map(Object::toString).collect(Collectors.joining(","));
            pilotRegistrationDO.setIndustryAppAuth(industryAppAuth);
        }
        flyerTrainingDao.insertPilotRegistrationInfo(pilotRegistrationDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody getDronePilotLicense() {
        List<DronePilotLicenseVO> allLicenses = flyerTrainingDao.selectAllLicenses();
        List<DronePilotLicenseVO> topLevelLicenses = new ArrayList<>();
        Map<Integer, DronePilotLicenseVO> licenseMap = new HashMap<>();

        // 将每个数据模型对象添加到Map中，以便在递归过程中查找它们的父母
        for (DronePilotLicenseVO license : allLicenses) {
            license.setChildLicenses(new ArrayList<>());
            licenseMap.put(license.getId(), license);
        }

        // 构建树结构
        for (DronePilotLicenseVO license : allLicenses) {
            if (license.getParentId() == 0) {
                topLevelLicenses.add(license);
            } else {
                DronePilotLicenseVO parent = licenseMap.get(license.getParentId());
                parent.getChildLicenses().add(license);
            }
        }
        return ResultBody.success(topLevelLicenses);
    }

    @Override
    public ResultBody getIndustryFlightSkills() {
        List<FlightSkillsDO> flightSkillsList = flyerTrainingDao.listIndustryFlightSkills();
        return ResultBody.success(flightSkillsList.stream()
                .map(FlightSkillsDO::buildFlightSkillsVO).collect(Collectors.toList()));
    }
}
