package com.mmc.csf.release.entity;

import com.mmc.csf.forum.vo.DynamicVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 动态信息表(ForumDynamicDO)实体类
 *
 * @author lw
 * @since 2023-05-16 09:50:39
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class ForumDynamicDO implements Serializable {
    private static final long serialVersionUID = 570379773690905364L;
    /**
     * 主键，自增长
     */
    private Integer id;
    /**
     * 版本字段pid
     */
    private Integer pid;
    /**
     * 动态标题
     */
    private String title;
    /**
     * 发布用户ID
     */
    private Integer userId;
    /**
     * 动态描述
     */
    private String description;
    /**
     * 发布动态具体位置
     */
    private String location;
    /**
     * 发布动态纬度
     */
    private BigDecimal lat;
    /**
     * 发布动态经度
     */
    private BigDecimal lon;
    /**
     * 点赞数
     */
    private Integer likesCount;
    /**
     * 评论数
     */
    private Integer commentsCount;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date updateTime;
    /**
     * 是否删除，默认为0表示未删除
     */
    private Integer deleted;

    public ForumDynamicDO(DynamicVO dynamicVO) {
        this.title = dynamicVO.getTitle();
        this.description = dynamicVO.getDescription();
        this.userId = dynamicVO.getUserId();
        this.location = dynamicVO.getLocation();
        this.lat = dynamicVO.getLat();
        this.lon = dynamicVO.getLon();
    }

    public DynamicVO buildDynamicVO() {
        return DynamicVO.builder().id(id).description(description)
                .commentCount(commentsCount).likesCount(likesCount)
                .lat(lat).lon(lon).location(location).title(title)
                .userId(userId).build();
    }
}

