package com.mmc.csf.release.mq.listener;

import com.alibaba.fastjson.JSONObject;
import com.github.xiaoymin.knife4j.core.util.CollectionUtils;
import com.mmc.csf.release.constant.RabbitmqConstant;
import com.mmc.csf.release.dao.DynamicDAO;
import com.mmc.csf.release.dao.LikeDAO;
import com.mmc.csf.release.entity.forum.ForumDynamicDO;
import com.mmc.csf.user.vo.UserAccountVO;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author LW
 *
 * @date 2023/6/29 10:35 概要：
 */
@Slf4j
@Component
public class MqConsumer {
  @Autowired DynamicDAO dynamicDAO;
  @Autowired LikeDAO likeDAO;

  @RabbitListener(queues = RabbitmqConstant.USER_INFO_UPDATE_FANOUT_FORUM_QUEUE)
  public void subscribeFanoutQueue(@Payload String userAccount, Channel channel, Message message) {
    UserAccountVO userAccountVO = JSONObject.parseObject(userAccount, UserAccountVO.class);
    log.info("用户信息更改====>论坛消费者消费开始：用户信息是---->{}", userAccount);
    if (userAccountVO.getDeleted() != null && userAccountVO.getDeleted().equals(1)) {
      // 删除关于该用户的所有动态及评论和点赞信息
      List<ForumDynamicDO> forumDynamicList = dynamicDAO.listDynamicByUserId(userAccountVO.getId());
      if (CollectionUtils.isNotEmpty(forumDynamicList)) {
        List<Integer> dynamicIds =
            forumDynamicList.stream().map(ForumDynamicDO::getId).collect(Collectors.toList());
        dynamicDAO.batchDeleteDynamic(dynamicIds);
      }
    }
    log.info("用户信息更改====>论坛消费者消费结束。");
  }
}
