package com.mmc.csf.infomation.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.mmc.csf.release.model.group.Insert;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/5/18 15:14
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class RequirementsInfoVO implements Serializable {
    private static final long serialVersionUID = -447951390213113317L;
    @ApiModelProperty(value = "id", hidden = true)
    @NotNull(message = "id不能为空", groups = {Update.class})
    private Integer id;

    private Integer tempId;

    @ApiModelProperty(value = "需求发布id", hidden = true)
    private Integer requirementsInfoId;

    @ApiModelProperty(value = "需求类型id", example = "1", required = true)
    @NotNull(message = "需求类型id不能为空", groups = {Insert.class, Update.class})
    private Integer requirementTypeId;

    @ApiModelProperty(value = "任务标题", example = "任务标题001", required = true)
    @Size(max = 15, message = "任务标题限制15个字")
    @NotBlank(message = "任务标题不能为空", groups = {Insert.class, Update.class})
    private String taskTitle;

    @ApiModelProperty(value = "任务开始时间", example = "2023-07-25", required = true)
    @NotNull(message = "任务开始时间不能为空", groups = {Insert.class, Update.class})
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private String taskStartTime;

    @ApiModelProperty(value = "任务结束时间", example = "2023-07-26", required = true)
    @NotNull(message = "任务开始时间不能为空", groups = {Insert.class, Update.class})
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private String taskEndTime;

    @ApiModelProperty(value = "任务地址", example = "广东省深圳市", required = true)
    @NotBlank(message = "任务地址不能为空", groups = {Insert.class, Update.class})
    private String taskAddress;


    @ApiModelProperty(value = "任务经度", example = "23.344324")
    private Double longitude;

    @ApiModelProperty(value = "任务纬度", example = "44.344324")
    private Double latitude;


    @ApiModelProperty(value = "当前订单状态")
    private Integer serviceFlowId;

    @ApiModelProperty(value = "订单的父订单id")
    private Integer fatherRequireId;

    @ApiModelProperty(value = "需求描述", example = "描述一下", required = true)
    @NotNull(message = "需求描述不能为空", groups = {Insert.class})
    @Length(max = 300, message = "字符过长")
    private String requireDescription;

    @ApiModelProperty(value = "描述图片", example = "http://,http://", required = false)
    private String requireUrl;

    @ApiModelProperty(value = "发布者姓名", example = "张三")
    // @NotNull(message = "发布者姓名不能为空", groups = {Insert.class})
    private String publishName;

    @ApiModelProperty(value = "发布者电话", example = "1892994543", required = true)
    @NotNull(message = "发布者电话不能为空", groups = {Insert.class})
    private String publishPhone;



    /**
     * 后台获取token里面的用户id
     */
    @ApiModelProperty(value = "用户id", hidden = true)
    //@NotNull(message = "用户id不能为空", groups = {Insert.class})
    private Integer userAccountId;

    @ApiModelProperty(value = "发布者支付总金额", example = "发布者支付总金额")
    private BigDecimal totalAmount;
    @ApiModelProperty(value = "省份编码", required = false)
    //@NotNull(message = "省份编码不能为空", groups = {Insert.class})
    private Integer provinceCode;
    @ApiModelProperty(value = "市编码", required = false)
    private Integer cityCode;
    @ApiModelProperty(value = "区编码", required = false)
    private Integer districtCode;


    @ApiModelProperty(value = "是否已解决")
    private Boolean solved;


    @ApiModelProperty(value = "类型名称", hidden = true)
    private String requirementTypeName;


    @ApiModelProperty(value = "订单编号")
    private String orderNumber;

    @ApiModelProperty(value = "应支付金额 单位元", example = "1.00")
    private BigDecimal paramMoney;

    @ApiModelProperty(value = "发布者id", example = "1", required = true)
    private Integer publishAccountId;

    @ApiModelProperty(value = "发布者订单编号")
    private String publisherNumber;

    @ApiModelProperty(value = "订单级别", example = "订单级别", required = true)
    @NotNull(message = "订单级别", groups = {Insert.class})
    private String orderLevelEnum;

    @ApiModelProperty(value = "服务id", example = "服务id", required = true)
    private Integer serviceId;

    @ApiModelProperty(value = "服务名称", example = "服务名称")
    private String serviceName;

    @ApiModelProperty(value = "飞手保险 1飞手保险 2三者保险 3机身保险", example = "飞手保险 1飞手保险 2三者保险 3机身保险")
    private String insurance;

    @ApiModelProperty(value = "当前状态", example = "已发布")
    private String doing;
    @ApiModelProperty(value = "等待状态", example = "等待抢单")
    private String waiting;
    @ApiModelProperty(value = "发布者状态", example = "等待抢单")
    private String userPort;
    @ApiModelProperty(value = "飞手状态", example = "等待抵达现场")
    private String flyerPort;
    @ApiModelProperty(value = "状态编码", example = "状态编码")
    private String orderStatus;
    @ApiModelProperty(value = "0需求信息 1是服务需求", example = "0需求信息 1是服务需求")
    private Integer publish;
    @ApiModelProperty(value = "抢单者已支付的总金额", example = "抢单者已支付的总金额")
    private BigDecimal preemptTotalAmount;

    @ApiModelProperty(value = "任务佣金", example = "任务佣金")
    private BigDecimal orderAmount;

    @ApiModelProperty(value = "订单级别 REGULAR_ORDER,RUSH_ORDER,TOP_ORDER", example = "订单级别 REGULAR_ORDER,RUSH_ORDER,TOP_ORDER")
    private BigDecimal orderLevel;


    @ApiModelProperty(value = "修格后的任务佣金")
    private BigDecimal updateOrderAmount;

    @ApiModelProperty(value = "原因")
    private String reason;

    @ApiModelProperty(value = "原因url")
    private String url;

    @ApiModelProperty(value = "修改后原因")
    private String afterModificationReason;

    @ApiModelProperty(value = "修改后url")
    private String afterModificationUrl;

    @ApiModelProperty(value = "抢单者电话")
    private String preemptPhone;

    @ApiModelProperty(value = "抢单飞手用户id ")
    private Integer pilotCertificationUserId;

    @ApiModelProperty(value = "抢单飞手id")
    private Integer pilotCertificationId;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "还剩多少人可以抢单")
    private Integer repertory;

    @ApiModelProperty(value = "订单共需多少人")
    private Integer requireNum;

    @ApiModelProperty(value = "后台修改后的金额")
    private BigDecimal changedOrderAmount;

    @ApiModelProperty(value = "管理员操作")
    private int teamStatus;

    @ApiModelProperty(value = "二级分类id")
    private int inspectionId;

    @ApiModelProperty(value = "项目号")
    private String projectCode;

    @ApiModelProperty(value = "二级分类名称")
    private String inspectionName;
}
