package com.mmc.csf.release.controller;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.vo.RequirementsInfoVO;
import com.mmc.csf.infomation.vo.RequirementsTypeVO;
import com.mmc.csf.release.model.group.Insert;
import com.mmc.csf.release.model.group.Page;
import com.mmc.csf.release.model.group.Query;
import com.mmc.csf.release.service.RequirementsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/5/18 14:26
 */
@Api(tags = {"需求相关"})
@RestController
@RequestMapping("/requirements/")
public class RequirementsController extends BaseController{

    @Autowired
    private RequirementsService requirementsService;

    @ApiOperation(value = "需求类型")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = RequirementsTypeVO.class) })
    @GetMapping("listType")
    public ResultBody listType(){
        return requirementsService.listType();
    }

    @ApiOperation(value = "需求发布")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("publish")
    public ResultBody publish(@Validated(value = {Insert.class})@RequestBody RequirementsInfoVO requirementsInfoVO, HttpServletRequest request){
        requirementsInfoVO.setUserAccountId(this.getUserLoginInfoFromRedis(request).getUserAccountId());
        return requirementsService.publish(requirementsInfoVO, request);
    }

    @ApiOperation(value = "需求发布列表")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = RequirementsInfoVO.class) })
    @PostMapping("listPublishPage")
    public ResultBody listPublishPage(@Validated(value = {Page.class})@RequestBody IndustryCaseQO industryCaseQO, HttpServletRequest request){
        return requirementsService.listPublishPage(industryCaseQO, request);
    }

    @ApiOperation(value = "需求已解决")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @GetMapping("solveRequire")
    public ResultBody solveRequire(@RequestParam Integer requirementsInfoId, HttpServletRequest request){
        return requirementsService.solveRequire(requirementsInfoId, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

}
