package com.mmc.csf.release.service.impl;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.config.IsNullConvertZeroUtil;
import com.mmc.csf.infomation.dto.*;
import com.mmc.csf.infomation.qo.ServiceOrderQO;
import com.mmc.csf.infomation.vo.RequireEveryStatusVO;
import com.mmc.csf.release.auth.dto.LoginSuccessDTO;
import com.mmc.csf.release.dao.BackRequirementsDao;
import com.mmc.csf.release.dao.RequirementsDao;
import com.mmc.csf.release.entity.requirements.ServiceOrderFormDO;
import com.mmc.csf.release.entity.requirements.ServiceOrderFormDetailsDO;
import com.mmc.csf.release.feign.UserAppApi;
import com.mmc.csf.release.service.BackRequirementsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author small
 * @Date 2023/8/29 10:20
 * @Version 1.0
 */
@Service
public class BackRequirementsServiceImpl implements BackRequirementsService {

    @Autowired
    private BackRequirementsDao backRequirementsDao;
    @Autowired
    private RequirementsDao requirementsDao;

    @Autowired
    private UserAppApi userAppApi;

    @Override
    public PageResult serviceOrderFormList(ServiceOrderQO param, LoginSuccessDTO userLoginInfoFromRedis) {

        //权限限制，除了admin以外其他飞手团队后台账号只能看到自己团队里面飞手接的订单
        Integer userAccountId = userLoginInfoFromRedis.getUserAccountId();
        if(userAccountId != 1) {
            List<Integer> pilotUserIdList = userAppApi.feignGetPilotIdList(userLoginInfoFromRedis.getToken());
            if(pilotUserIdList == null) {
                return PageResult.buildPage(param.getPageNo(), param.getPageSize(), 0);
            }
            param.setPilotUserIdList(pilotUserIdList);
        }

        int count = backRequirementsDao.countService(param);
        if (count == 0) {
            return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
        }
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<ServiceOrderFormDO> serviceOrderFormDOS = backRequirementsDao.serviceOrderFormList(param);
        List<ServiceOrderFormDTO> collect = serviceOrderFormDOS.stream().map(ServiceOrderFormDO::buildServiceOrderForm).collect(Collectors.toList());
        return PageResult.buildPage(pageNo, param.getPageSize(), count, collect);
    }


    @Override
    public ResultBody serviceOrderFormDetails(Integer requirementsInfoId, LoginSuccessDTO userLoginInfoFromRedis) {

        RequireEveryStatusVO requireEveryStatusVO = new RequireEveryStatusVO();
        //抵达现场
        ServiceArriveSceneDTO arriveSceneDTO = requirementsDao.serviceArriveSceneDTO(requirementsInfoId);
        requireEveryStatusVO.setServiceArriveSceneDTO(arriveSceneDTO);
        //完成任务
        ServiceFulfilATaskDTO fulfilATaskDTO = requirementsDao.serviceFulfilATaskDTO(requirementsInfoId);
        requireEveryStatusVO.setServiceFulfilATaskDTO(fulfilATaskDTO);
        //评价
        ServiceEvaluateDTO serviceEvaluateDTO = requirementsDao.serviceEvaluateDTO(requirementsInfoId);
        requireEveryStatusVO.setServiceEvaluateDTO(serviceEvaluateDTO);
//修改金额
        RequirementsAmountUpdateDTO requirementsAmountUpdateDTO = requirementsDao.amountUpdateDTO(requirementsInfoId);
        requireEveryStatusVO.setAmountUpdate(requirementsAmountUpdateDTO);

        ServiceOrderFormDetailsDO orderFormDetailsDO = backRequirementsDao.serviceOrderFormDetails(requirementsInfoId);
        ServiceOrderFormDetailsDTO serviceOrderFormDetailsDTO = orderFormDetailsDO.buildOrderFormDetails();
        IsNullConvertZeroUtil.checkIsNull(serviceOrderFormDetailsDTO);

        requireEveryStatusVO.setServiceOrderFormDetailsDTO(serviceOrderFormDetailsDTO);

        return ResultBody.success(requireEveryStatusVO);
    }
}
