package com.mmc.csf.release.util;

import com.mmc.csf.common.util.web.ResultBody;
import org.apache.log4j.Logger;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @Author small
 * @Date 2023/6/15 16:53
 * @Version 1.0
 */
@ControllerAdvice
public class VaildExceptionConfig  extends ResultBody {

    private static final Logger logger = Logger.getLogger(VaildExceptionConfig.class);

    @ResponseBody
    @ExceptionHandler(MethodArgumentNotValidException.class)
    public ResultBody throwCustomException(MethodArgumentNotValidException methodArgumentNotValidException){

        logger.error("[ @Vaild异常捕获 ] " + methodArgumentNotValidException.getMessage());

        ResultBody resultBody = new ResultBody();
        resultBody.setCode("400");
        resultBody.setMessage(methodArgumentNotValidException.getBindingResult().getFieldError().getDefaultMessage());

        return resultBody;
    }
}
