package com.mmc.csf.release.entity;

import com.mmc.csf.infomation.dto.BannerInfoDTO;
import com.mmc.csf.infomation.vo.BannerInfoVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/23 14:28
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class BannerInfoDO implements Serializable {
    private static final long serialVersionUID = 1041918314535866878L;
    private Integer id;
    private Integer moduleId;
    private String bannerName;
    private String bannerImg;
    private Integer bannerType;
    private Integer goodsId;
    private String bannerPoster;
    private String bannerUrl;
    private String detailInfo;
    private Integer sort;
    private String textContent;
    private Date startTime;
    private Date endTime;
    private Integer using;
    private Integer deleted;
    private Date createTime;
    private Date updateTime;

    public BannerInfoDTO buildBannerInfoDTO(){
        Date now = new Date();
        return BannerInfoDTO.builder().id(this.id).moduleId(this.moduleId).bannerName(this.bannerName).bannerImg(this.bannerImg)
                .bannerPoster(this.bannerPoster).sort(this.sort).using(this.endTime != null ? ( now.before(this.endTime) ? (this.using == 1 ? 1 : 0) : 0 ) : (this.using == 1 ? 1 : 0))
                .deleted(this.deleted).createTime(this.createTime).bannerType(this.bannerType).goodsId(this.goodsId).bannerUrl(this.bannerUrl).textContent(this.textContent)
                .detailInfo(this.detailInfo).startTime(this.startTime).endTime(this.endTime).build();
    }

    public BannerInfoDO(BannerInfoVO bannerInfoVO){
        this.id = bannerInfoVO.getId();
        this.moduleId = bannerInfoVO.getModuleId();
        this.bannerName = bannerInfoVO.getBannerName();
        this.bannerImg = bannerInfoVO.getBannerImg();
        this.bannerType = bannerInfoVO.getBannerType();
        this.bannerPoster = bannerInfoVO.getBannerPoster();
        this.bannerUrl = bannerInfoVO.getBannerUrl();
        this.sort = bannerInfoVO.getSort();
        this.using = bannerInfoVO.getUsing();
        this.goodsId = bannerInfoVO.getGoodsId();
        this.detailInfo = bannerInfoVO.getDetailInfo();
        this.startTime = bannerInfoVO.getStartTime();
        this.endTime = bannerInfoVO.getEndTime();
        this.textContent = bannerInfoVO.getTextContent();
    }
}
